/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.parser;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.html.EHTMLElement;
import com.helger.html.EHTMLVersion;
import com.helger.html.entity.HTMLEntityResolver;
import com.helger.xml.EXMLParserFeature;
import com.helger.xml.microdom.IMicroContainer;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroDocumentType;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroContainer;
import com.helger.xml.microdom.serialize.MicroReader;
import com.helger.xml.serialize.read.ISAXReaderSettings;
import com.helger.xml.serialize.read.SAXReaderSettings;
import com.helger.xml.serialize.write.EXMLIncorrectCharacterHandling;
import com.helger.xml.serialize.write.EXMLSerializeVersion;
import com.helger.xml.serialize.write.XMLEmitter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.xml.sax.EntityResolver;

@NotThreadSafe
public class XHTMLParser {
    private final EHTMLVersion m_eHTMLVersion;
    private SAXReaderSettings m_aAdditionalSAXReaderSettings = new SAXReaderSettings().setFeatureValue(EXMLParserFeature.SECURE_PROCESSING, true).setFeatureValue(EXMLParserFeature.EXTERNAL_GENERAL_ENTITIES, false);

    public XHTMLParser(@Nonnull EHTMLVersion eHTMLVersion) {
        this.m_eHTMLVersion = (EHTMLVersion)((Object)ValueEnforcer.notNull((Object)((Object)eHTMLVersion), (String)"HTMLVersion"));
    }

    @Nonnull
    public EHTMLVersion getHTMLVersion() {
        return this.m_eHTMLVersion;
    }

    @Nonnull
    @ReturnsMutableCopy
    public SAXReaderSettings getAdditionalSAXReaderSettings() {
        return this.m_aAdditionalSAXReaderSettings.getClone();
    }

    public void setAdditionalSAXReaderSettings(@Nullable ISAXReaderSettings iSAXReaderSettings) {
        this.m_aAdditionalSAXReaderSettings = SAXReaderSettings.createCloneOnDemand((ISAXReaderSettings)iSAXReaderSettings);
    }

    public static boolean looksLikeXHTML(@Nullable String string) {
        return StringHelper.hasText((String)string) && RegExHelper.stringMatchesPattern((String)"(?s).*<[a-zA-Z].+", (String)string);
    }

    public boolean isValidXHTMLFragment(@Nullable String string) {
        return StringHelper.hasNoText((String)string) || this.parseXHTMLFragment(string) != null;
    }

    @Nullable
    public IMicroDocument parseXHTMLFragment(@Nullable String string) {
        String string2 = this.m_eHTMLVersion.getNamespaceURI();
        String string3 = XMLEmitter.getDocTypeHTMLRepresentation((EXMLSerializeVersion)EXMLSerializeVersion.XML_10, (EXMLIncorrectCharacterHandling)EXMLIncorrectCharacterHandling.DEFAULT, (IMicroDocumentType)this.m_eHTMLVersion.getDocType()) + "<html" + (string2 != null ? " xmlns=\"" + string2 + '\"' : "") + "><head><title></title></head><body>" + StringHelper.getNotNull((String)string) + "</body></html>";
        return this.parseXHTMLDocument(string3);
    }

    @Nullable
    public IMicroDocument parseXHTMLDocument(@Nullable String string) {
        return MicroReader.readMicroXML((String)string, (ISAXReaderSettings)this.m_aAdditionalSAXReaderSettings.getClone().setEntityResolver((EntityResolver)HTMLEntityResolver.getInstance()));
    }

    @Nullable
    public IMicroContainer unescapeXHTMLFragment(@Nullable String string) {
        IMicroElement iMicroElement;
        IMicroDocument iMicroDocument = this.parseXHTMLFragment(string);
        if (iMicroDocument != null && iMicroDocument.getDocumentElement() != null && (iMicroElement = iMicroDocument.getDocumentElement().getFirstChildElement(EHTMLElement.BODY.getElementName())) != null) {
            MicroContainer microContainer = new MicroContainer();
            if (iMicroElement.hasChildren()) {
                for (IMicroNode iMicroNode : iMicroElement.getAllChildren()) {
                    microContainer.appendChild(iMicroNode.detachFromParent());
                }
            }
            return microContainer;
        }
        return null;
    }
}

