/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.resource.js;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.js.JSFilenameHelper;
import com.helger.html.resource.js.IJSPathProvider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ConstantJSPathProvider
implements IJSPathProvider {
    private final String m_sPath;
    private final String m_sMinifiedPath;
    private final String m_sConditionalComment;
    private final boolean m_bIsBundlable;

    public ConstantJSPathProvider(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable String string3, boolean bl) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Path");
        ValueEnforcer.isTrue((boolean)JSFilenameHelper.isJSFilename(string), () -> "'" + string + "' is not a valid JS filename");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"MinifiedPath");
        ValueEnforcer.isTrue((boolean)JSFilenameHelper.isJSFilename(string2), () -> "'" + string2 + "' is not a valid minified JS filename");
        this.m_sPath = string;
        this.m_sMinifiedPath = string2;
        this.m_sConditionalComment = string3;
        this.m_bIsBundlable = bl;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getJSItemPath(boolean bl) {
        return bl ? this.m_sPath : this.m_sMinifiedPath;
    }

    @Nonnull
    @Nonempty
    public String getJSItemPathRegular() {
        return this.m_sPath;
    }

    @Nonnull
    @Nonempty
    public String getJSItemPathMinified() {
        return this.m_sMinifiedPath;
    }

    @Override
    @Nullable
    public String getConditionalComment() {
        return this.m_sConditionalComment;
    }

    @Override
    public boolean isBundlable() {
        return this.m_bIsBundlable;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ConstantJSPathProvider constantJSPathProvider = (ConstantJSPathProvider)object;
        return this.m_sPath.equals(constantJSPathProvider.m_sPath) && this.m_sMinifiedPath.equals(constantJSPathProvider.m_sMinifiedPath) && EqualsHelper.equals((Object)this.m_sConditionalComment, (Object)constantJSPathProvider.m_sConditionalComment) && this.m_bIsBundlable == constantJSPathProvider.m_bIsBundlable;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sPath).append((Object)this.m_sMinifiedPath).append((Object)this.m_sConditionalComment).append(this.m_bIsBundlable).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("path", (Object)this.m_sPath).append("minifiedPath", (Object)this.m_sMinifiedPath).appendIfNotNull("conditionalComment", (Object)this.m_sConditionalComment).append("isBundlable", this.m_bIsBundlable).getToString();
    }

    @Nonnull
    public static ConstantJSPathProvider create(@Nonnull @Nonempty String string) {
        return new ConstantJSPathProvider(string, JSFilenameHelper.getMinifiedJSFilename(string), DEFAULT_CONDITIONAL_COMMENT, true);
    }

    @Nonnull
    public static ConstantJSPathProvider createWithConditionalComment(@Nonnull @Nonempty String string, @Nullable String string2) {
        return new ConstantJSPathProvider(string, JSFilenameHelper.getMinifiedJSFilename(string), string2, true);
    }

    @Nonnull
    public static ConstantJSPathProvider createBundlable(@Nonnull @Nonempty String string, boolean bl) {
        return new ConstantJSPathProvider(string, JSFilenameHelper.getMinifiedJSFilename(string), DEFAULT_CONDITIONAL_COMMENT, bl);
    }

    @Nonnull
    public static ConstantJSPathProvider createExternal(@Nonnull @Nonempty String string) {
        return ConstantJSPathProvider.createExternal(string, DEFAULT_CONDITIONAL_COMMENT);
    }

    @Nonnull
    public static ConstantJSPathProvider createExternal(@Nonnull @Nonempty String string, @Nullable String string2) {
        return new ConstantJSPathProvider(string, string, string2, false);
    }
}

