/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.string.StringHelper;
import com.helger.html.EHTMLContentModelType;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EHTMLElement {
    A("a", false, EHTMLContentModelType.FLOW),
    ABBR("abbr", false, EHTMLContentModelType.PHRASING),
    ADDRESS("address", false, EHTMLContentModelType.FLOW),
    APPLET("applet", false, EHTMLContentModelType.FLOW),
    AREA("area", true, EHTMLContentModelType.PHRASING),
    ARTICLE("article", false, EHTMLContentModelType.FLOW),
    ASIDE("aside", false, EHTMLContentModelType.FLOW),
    AUDIO("audio", false, EHTMLContentModelType.FLOW),
    B("b", false, EHTMLContentModelType.PHRASING),
    BASE("base", true, EHTMLContentModelType.NOTHING),
    BDI("bdi", false, EHTMLContentModelType.PHRASING),
    BDO("bdo", false, EHTMLContentModelType.PHRASING),
    BLOCKQUOTE("blockquote", false, EHTMLContentModelType.FLOW),
    BODY("body", false, EHTMLContentModelType.FLOW),
    BR("br", true, EHTMLContentModelType.PHRASING),
    BUTTON("button", false, EHTMLContentModelType.PHRASING),
    CANVAS("canvas", false, EHTMLContentModelType.FLOW),
    CAPTION("caption", false, EHTMLContentModelType.FLOW),
    CENTER("center", false, EHTMLContentModelType.LEGACY_PHRASING),
    CITE("cite", false, EHTMLContentModelType.PHRASING),
    CODE("code", false, EHTMLContentModelType.PHRASING),
    COL("col", true, EHTMLContentModelType.NOTHING),
    COLGROUP("colgroup", false, EHTMLContentModelType.CHILD),
    COMMAND("command", false, EHTMLContentModelType.PHRASING_METADATA),
    DATA("data", false, EHTMLContentModelType.PHRASING),
    DATALIST("datalist", false, EHTMLContentModelType.PHRASING),
    DD("dd", false, EHTMLContentModelType.FLOW),
    DEL("del", false, EHTMLContentModelType.FLOW),
    DETAILS("details", false, EHTMLContentModelType.FLOW),
    DFN("dfn", false, EHTMLContentModelType.PHRASING),
    DIALOG("dialog", false, EHTMLContentModelType.FLOW),
    DIR("dir", false, EHTMLContentModelType.LEGACY_PHRASING),
    DIV("div", false, EHTMLContentModelType.FLOW),
    DL("dl", false, EHTMLContentModelType.FLOW),
    DT("dt", false, EHTMLContentModelType.FLOW),
    EM("em", false, EHTMLContentModelType.PHRASING),
    EMBED("embed", true, EHTMLContentModelType.PHRASING),
    FIELDSET("fieldset", false, EHTMLContentModelType.FLOW),
    FIGCAPTION("figcaption", false, EHTMLContentModelType.FLOW),
    FIGURE("figure", false, EHTMLContentModelType.FLOW),
    FONT("font", false, EHTMLContentModelType.UNDEFINED),
    FOOTER("footer", false, EHTMLContentModelType.FLOW),
    FORM("form", false, EHTMLContentModelType.FLOW),
    FRAME("frame", true, EHTMLContentModelType.UNDEFINED),
    FRAMESET("frameset", false, EHTMLContentModelType.UNDEFINED),
    H1("h1", false, EHTMLContentModelType.FLOW),
    H2("h2", false, EHTMLContentModelType.FLOW),
    H3("h3", false, EHTMLContentModelType.FLOW),
    H4("h4", false, EHTMLContentModelType.FLOW),
    H5("h5", false, EHTMLContentModelType.FLOW),
    H6("h6", false, EHTMLContentModelType.FLOW),
    HEAD("head", false, EHTMLContentModelType.SPECIAL),
    HEADER("header", false, EHTMLContentModelType.FLOW),
    HGROUP("hgroup", false, EHTMLContentModelType.FLOW),
    HR("hr", true, EHTMLContentModelType.FLOW),
    HTML("html", false, EHTMLContentModelType.SPECIAL),
    I("i", false, EHTMLContentModelType.PHRASING),
    IFRAME("iframe", false, EHTMLContentModelType.PHRASING),
    IMG("img", true, EHTMLContentModelType.PHRASING),
    INS("ins", false, EHTMLContentModelType.FLOW),
    INPUT("input", true, EHTMLContentModelType.PHRASING),
    KBD("kbd", false, EHTMLContentModelType.PHRASING),
    LABEL("label", false, EHTMLContentModelType.PHRASING),
    LEGEND("legend", false, EHTMLContentModelType.CHILD),
    LI("li", false, EHTMLContentModelType.CHILD),
    LINK("link", true, EHTMLContentModelType.METADATA),
    MAIN("main", false, EHTMLContentModelType.FLOW),
    MAP("map", false, EHTMLContentModelType.FLOW),
    MARK("mark", false, EHTMLContentModelType.PHRASING),
    MENU("menu", false, EHTMLContentModelType.FLOW),
    MENUITEM("menuitem", false, EHTMLContentModelType.FLOW),
    META("meta", true, EHTMLContentModelType.METADATA),
    METER("meter", false, EHTMLContentModelType.PHRASING),
    NAV("nav", false, EHTMLContentModelType.FLOW),
    NOBR("nobr", false, EHTMLContentModelType.UNDEFINED),
    NOSCRIPT("noscript", false, EHTMLContentModelType.FLOW_METADATA),
    OBJECT("object", false, EHTMLContentModelType.FLOW),
    OL("ol", false, EHTMLContentModelType.FLOW),
    OPTGROUP("optgroup", false, EHTMLContentModelType.CHILD),
    OPTION("option", false, EHTMLContentModelType.CHILD),
    OUTPUT("output", false, EHTMLContentModelType.PHRASING),
    P("p", false, EHTMLContentModelType.PHRASING),
    PARAM("param", false, EHTMLContentModelType.CHILD),
    PICTURE("picture", false, EHTMLContentModelType.FLOW_METADATA),
    PRE("pre", false, EHTMLContentModelType.FLOW),
    PROGRESS("progress", false, EHTMLContentModelType.PHRASING),
    RP("rp", false, EHTMLContentModelType.CHILD),
    RT("rt", false, EHTMLContentModelType.CHILD),
    RUBY("ruby", false, EHTMLContentModelType.PHRASING),
    Q("q", false, EHTMLContentModelType.PHRASING),
    S("s", false, EHTMLContentModelType.PHRASING),
    SAMP("samp", false, EHTMLContentModelType.PHRASING),
    SCRIPT("script", false, EHTMLContentModelType.PHRASING_METADATA),
    SECTION("section", false, EHTMLContentModelType.FLOW),
    SELECT("select", false, EHTMLContentModelType.PHRASING),
    SLOT("slot", false, EHTMLContentModelType.TRANSPARENT),
    SMALL("small", false, EHTMLContentModelType.PHRASING),
    SOURCE("source", true, EHTMLContentModelType.CHILD),
    SPAN("span", false, EHTMLContentModelType.PHRASING),
    STRONG("strong", false, EHTMLContentModelType.PHRASING),
    SUB("sub", false, EHTMLContentModelType.PHRASING),
    SUMMARY("summary", false, EHTMLContentModelType.CHILD),
    SUP("sup", false, EHTMLContentModelType.PHRASING),
    STYLE("style", false, EHTMLContentModelType.METADATA),
    TABLE("table", false, EHTMLContentModelType.FLOW),
    TBODY("tbody", false, EHTMLContentModelType.CHILD),
    TD("td", false, EHTMLContentModelType.CHILD),
    TEXTAREA("textarea", false, EHTMLContentModelType.PHRASING),
    TEMPLATE("template", false, EHTMLContentModelType.SPECIAL),
    TFOOT("tfoot", false, EHTMLContentModelType.CHILD),
    TH("th", false, EHTMLContentModelType.CHILD),
    THEAD("thead", false, EHTMLContentModelType.CHILD),
    TIME("time", false, EHTMLContentModelType.PHRASING),
    TITLE("title", false, EHTMLContentModelType.CHILD),
    TR("tr", false, EHTMLContentModelType.CHILD),
    TRACK("track", true, EHTMLContentModelType.CHILD),
    U("u", false, EHTMLContentModelType.PHRASING),
    UL("ul", false, EHTMLContentModelType.FLOW),
    VAR("var", false, EHTMLContentModelType.PHRASING),
    VIDEO("video", false, EHTMLContentModelType.FLOW),
    WBR("wbr", true, EHTMLContentModelType.PHRASING);

    private static final ICommonsSet<String> SELF_CLOSED_ELEMENTS_LC;
    private final String m_sElementNameLC;
    private final String m_sElementNameUC;
    private final boolean m_bMayBeSelfClosed;
    private final EHTMLContentModelType m_eType;

    @Nonnull
    public static String getUnifiedHTMLElementName(@Nonnull String string) {
        return string.toLowerCase(Locale.US);
    }

    private EHTMLElement(@Nonnull String string2, boolean bl, EHTMLContentModelType eHTMLContentModelType) {
        this.m_sElementNameLC = EHTMLElement.getUnifiedHTMLElementName(string2);
        this.m_sElementNameUC = string2.toUpperCase(Locale.US);
        this.m_bMayBeSelfClosed = bl;
        this.m_eType = eHTMLContentModelType;
    }

    @Nonnull
    @Nonempty
    public String getElementName() {
        return this.m_sElementNameLC;
    }

    @Nonnull
    @Nonempty
    public String getElementNameUpperCase() {
        return this.m_sElementNameUC;
    }

    public boolean mayBeSelfClosed() {
        return this.m_bMayBeSelfClosed;
    }

    public boolean mayNotBeSelfClosed() {
        return !this.m_bMayBeSelfClosed;
    }

    public boolean isFlowElement() {
        return this.m_eType.isFlowElement();
    }

    public boolean isMetadataElement() {
        return this.m_eType.isMetadataElement();
    }

    public boolean isPhrasingElement() {
        return this.m_eType.isPhrasingElement();
    }

    @Nonnull
    private static ICommonsSet<String> _getSelfClosedSet() {
        if (SELF_CLOSED_ELEMENTS_LC.isEmpty()) {
            for (EHTMLElement eHTMLElement : EHTMLElement.values()) {
                if (!eHTMLElement.mayBeSelfClosed()) continue;
                SELF_CLOSED_ELEMENTS_LC.add((Object)eHTMLElement.m_sElementNameLC);
            }
        }
        return SELF_CLOSED_ELEMENTS_LC;
    }

    public static boolean isTagThatMayBeSelfClosed(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return false;
        }
        return EHTMLElement._getSelfClosedSet().contains((Object)EHTMLElement.getUnifiedHTMLElementName(string));
    }

    public static boolean isTagThatMayNotBeSelfClosed(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return false;
        }
        return !EHTMLElement._getSelfClosedSet().contains((Object)EHTMLElement.getUnifiedHTMLElementName(string));
    }

    public static boolean isHTMLTagName(@Nullable String string) {
        return EHTMLElement.getFromTagNameOrNull(string) != null;
    }

    @Nullable
    public static EHTMLElement getFromTagNameOrNull(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            for (EHTMLElement eHTMLElement : EHTMLElement.values()) {
                if (!eHTMLElement.m_sElementNameLC.equalsIgnoreCase(string)) continue;
                return eHTMLElement;
            }
        }
        return null;
    }

    static {
        SELF_CLOSED_ELEMENTS_LC = new CommonsHashSet();
    }
}

