/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc;

import com.helger.commons.annotation.DevelopersNote;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.impl.HCTextNode;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IHCNodeWithChildren<IMPLTYPE extends IHCNodeWithChildren<IMPLTYPE>>
extends IHCHasChildrenMutable<IMPLTYPE, IHCNode> {
    @Override
    @Nonnull
    default public IMPLTYPE addChild(@Nullable String string) {
        if (string != null) {
            this.addChild(new HCTextNode(string));
        }
        return (IMPLTYPE)((IHCNodeWithChildren)this.thisAsT());
    }

    @Override
    @Nonnull
    default public IMPLTYPE setChild(@Nullable String string) {
        this.removeAllChildren();
        return this.addChild(string);
    }

    @Override
    @Nonnull
    default public IMPLTYPE addChildAt(@Nonnegative int n, @Nullable String string) {
        if (string != null) {
            this.addChildAt(n, new HCTextNode(string));
        }
        return (IMPLTYPE)((IHCNodeWithChildren)this.thisAsT());
    }

    @Override
    @Nonnull
    @Deprecated(forRemoval=false)
    @DevelopersNote(value="Use addChild instead")
    default public IMPLTYPE addChildren(@Nullable String string) {
        return this.addChild(string);
    }

    @Override
    @Nonnull
    default public IMPLTYPE addChildren(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                this.addChild(string);
            }
        }
        return (IMPLTYPE)((IHCNodeWithChildren)this.thisAsT());
    }
}

