/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.config;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.commons.system.ENewLineMode;
import com.helger.html.EHTMLVersion;
import com.helger.html.hc.IHCConversionSettings;
import com.helger.html.hc.config.DefaultHCOnDocumentReadyProvider;
import com.helger.html.hc.config.EHCScriptInlineMode;
import com.helger.html.hc.config.EHCStyleInlineMode;
import com.helger.html.hc.config.HCConversionSettings;
import com.helger.html.hc.config.IHCOnDocumentReadyProvider;
import com.helger.html.hc.config.IHCSettingsProviderSPI;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class HCSettings {
    public static final EHTMLVersion DEFAULT_HTML_VERSION = EHTMLVersion.HTML5;
    public static final boolean DEFAULT_AUTO_COMPLETE_OFF_FOR_PASSWORD_EDITS = !GlobalDebug.isDebugMode();
    public static final EHCScriptInlineMode DEFAULT_SCRIPT_INLINE_MODE = EHCScriptInlineMode.PLAIN_TEXT_NO_ESCAPE;
    public static final EHCStyleInlineMode DEFAULT_STYLE_MODE = EHCStyleInlineMode.PLAIN_TEXT_NO_ESCAPE;
    private static final Logger LOGGER = LoggerFactory.getLogger(HCSettings.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static HCConversionSettings s_aConversionSettings = new HCConversionSettings(DEFAULT_HTML_VERSION);
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bAutoCompleteOffForPasswordEdits = DEFAULT_AUTO_COMPLETE_OFF_FOR_PASSWORD_EDITS;
    @GuardedBy(value="RW_LOCK")
    private static int s_nTextAreaDefaultRows = -1;
    @GuardedBy(value="RW_LOCK")
    private static IHCOnDocumentReadyProvider s_aOnDocumentReadyProvider = new DefaultHCOnDocumentReadyProvider();
    @GuardedBy(value="RW_LOCK")
    private static EHCScriptInlineMode s_eScriptInlineMode = DEFAULT_SCRIPT_INLINE_MODE;
    @GuardedBy(value="RW_LOCK")
    private static EHCStyleInlineMode s_eStyleInlineMode = DEFAULT_STYLE_MODE;
    @GuardedBy(value="RW_LOCK")
    private static ENewLineMode s_eNewLineMode = ENewLineMode.DEFAULT;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bOOBDebugging = false;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bScriptsInBody = true;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bUseRegularResources = GlobalDebug.isDebugMode();
    private static final AtomicBoolean SILENT_MODE = new AtomicBoolean(true);

    private HCSettings() {
    }

    public static boolean isSilentMode() {
        return SILENT_MODE.get();
    }

    public static boolean setSilentMode(boolean bl) {
        return SILENT_MODE.getAndSet(bl);
    }

    public static void setConversionSettings(@Nonnull HCConversionSettings hCConversionSettings) {
        ValueEnforcer.notNull((Object)hCConversionSettings, (String)"ConversionSettings");
        RW_LOCK.writeLocked(() -> {
            s_aConversionSettings = hCConversionSettings;
        });
    }

    @Nonnull
    @ReturnsMutableObject
    public static HCConversionSettings getMutableConversionSettings() {
        return (HCConversionSettings)RW_LOCK.readLockedGet(() -> s_aConversionSettings);
    }

    @Nonnull
    public static IHCConversionSettings getConversionSettings() {
        return HCSettings.getMutableConversionSettings();
    }

    @Nonnull
    public static HCConversionSettings getConversionSettingsWithoutNamespaces() {
        HCConversionSettings hCConversionSettings = HCSettings.getMutableConversionSettings().getClone();
        hCConversionSettings.getXMLWriterSettings().setEmitNamespaces(false);
        return hCConversionSettings;
    }

    @Nonnull
    public static Charset getHTMLCharset() {
        return HCSettings.getConversionSettings().getXMLWriterSettings().getCharset();
    }

    public static void setDefaultHTMLVersion(@Nonnull EHTMLVersion eHTMLVersion) {
        ValueEnforcer.notNull((Object)((Object)eHTMLVersion), (String)"HTMLVersion");
        EHTMLVersion eHTMLVersion2 = HCSettings.getMutableConversionSettings().getHTMLVersion();
        HCSettings.getMutableConversionSettings().setHTMLVersion(eHTMLVersion);
        HCSettings.getMutableConversionSettings().setXMLWriterSettings((IXMLWriterSettings)HCConversionSettings.createDefaultXMLWriterSettings(eHTMLVersion));
        if (!eHTMLVersion.equals((Object)eHTMLVersion2) && !HCSettings.isSilentMode()) {
            LOGGER.info("Default HTML version changed from " + eHTMLVersion2 + " to " + eHTMLVersion);
        }
        if (eHTMLVersion.isAtLeastHTML5()) {
            if (HCSettings.getScriptInlineMode() != EHCScriptInlineMode.PLAIN_TEXT_NO_ESCAPE) {
                HCSettings.setScriptInlineMode(EHCScriptInlineMode.PLAIN_TEXT_NO_ESCAPE);
            }
        } else if (HCSettings.getScriptInlineMode() != DEFAULT_SCRIPT_INLINE_MODE) {
            HCSettings.setScriptInlineMode(DEFAULT_SCRIPT_INLINE_MODE);
        }
    }

    public static boolean isAutoCompleteOffForPasswordEdits() {
        return RW_LOCK.readLockedBoolean(() -> s_bAutoCompleteOffForPasswordEdits);
    }

    public static void setAutoCompleteOffForPasswordEdits(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bAutoCompleteOffForPasswordEdits = bl;
        });
        if (!HCSettings.isSilentMode()) {
            LOGGER.info("Default @autocomplete for <input type=password> set to " + (bl ? "off" : "on"));
        }
    }

    public static int getTextAreaDefaultRows() {
        return RW_LOCK.readLockedInt(() -> s_nTextAreaDefaultRows);
    }

    public static void setTextAreaDefaultRows(int n) {
        RW_LOCK.writeLocked(() -> {
            s_nTextAreaDefaultRows = n;
        });
        if (!HCSettings.isSilentMode()) {
            LOGGER.info("Default <textarea> rows set to " + n);
        }
    }

    @Nonnull
    public static IHCOnDocumentReadyProvider getOnDocumentReadyProvider() {
        return (IHCOnDocumentReadyProvider)RW_LOCK.readLockedGet(() -> s_aOnDocumentReadyProvider);
    }

    public static void setOnDocumentReadyProvider(@Nonnull IHCOnDocumentReadyProvider iHCOnDocumentReadyProvider) {
        ValueEnforcer.notNull((Object)iHCOnDocumentReadyProvider, (String)"OnDocumentReadyProvider");
        RW_LOCK.writeLocked(() -> {
            s_aOnDocumentReadyProvider = iHCOnDocumentReadyProvider;
        });
        if (!HCSettings.isSilentMode()) {
            LOGGER.info("Default JS onDocumentReady provider set to " + iHCOnDocumentReadyProvider);
        }
    }

    @Nonnull
    public static EHCScriptInlineMode getScriptInlineMode() {
        return (EHCScriptInlineMode)((Object)RW_LOCK.readLockedGet(() -> s_eScriptInlineMode));
    }

    public static void setScriptInlineMode(@Nonnull EHCScriptInlineMode eHCScriptInlineMode) {
        ValueEnforcer.notNull((Object)((Object)eHCScriptInlineMode), (String)"Mode");
        EHCScriptInlineMode eHCScriptInlineMode2 = HCSettings.getScriptInlineMode();
        RW_LOCK.writeLocked(() -> {
            s_eScriptInlineMode = eHCScriptInlineMode;
        });
        if (!eHCScriptInlineMode.equals((Object)eHCScriptInlineMode2) && !HCSettings.isSilentMode()) {
            LOGGER.info("Default <script> mode changed from " + eHCScriptInlineMode2 + " to " + eHCScriptInlineMode);
        }
    }

    @Nonnull
    public static EHCStyleInlineMode getStyleInlineMode() {
        return (EHCStyleInlineMode)((Object)RW_LOCK.readLockedGet(() -> s_eStyleInlineMode));
    }

    public static void setStyleInlineMode(@Nonnull EHCStyleInlineMode eHCStyleInlineMode) {
        ValueEnforcer.notNull((Object)((Object)eHCStyleInlineMode), (String)"mode");
        EHCStyleInlineMode eHCStyleInlineMode2 = HCSettings.getStyleInlineMode();
        RW_LOCK.writeLocked(() -> {
            s_eStyleInlineMode = eHCStyleInlineMode;
        });
        if (!eHCStyleInlineMode.equals((Object)eHCStyleInlineMode2) && !HCSettings.isSilentMode()) {
            LOGGER.info("Default <style> mode changed from " + eHCStyleInlineMode2 + " to " + eHCStyleInlineMode);
        }
    }

    @Nonnull
    public static ENewLineMode getNewLineMode() {
        return (ENewLineMode)RW_LOCK.readLockedGet(() -> s_eNewLineMode);
    }

    public static void setNewLineMode(@Nonnull ENewLineMode eNewLineMode) {
        ValueEnforcer.notNull((Object)eNewLineMode, (String)"NewLineMode");
        ENewLineMode eNewLineMode2 = HCSettings.getNewLineMode();
        RW_LOCK.writeLocked(() -> {
            s_eNewLineMode = eNewLineMode;
        });
        if (!eNewLineMode.equals((Object)eNewLineMode2) && !HCSettings.isSilentMode()) {
            LOGGER.info("Default new line mode changed from " + eNewLineMode2 + " to " + eNewLineMode);
        }
    }

    public static boolean isOutOfBandDebuggingEnabled() {
        return RW_LOCK.readLockedBoolean(() -> s_bOOBDebugging);
    }

    public static void setOutOfBandDebuggingEnabled(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bOOBDebugging = bl;
        });
        if (!HCSettings.isSilentMode()) {
            LOGGER.info("Default out-of-band debugging " + (bl ? "enabled" : "disabled"));
        }
    }

    public static boolean isScriptsInBody() {
        return RW_LOCK.readLockedBoolean(() -> s_bScriptsInBody);
    }

    public static void setScriptsInBody(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bScriptsInBody = bl;
        });
        if (!HCSettings.isSilentMode()) {
            LOGGER.info("Default put <scripts>s in " + (bl ? "<body>" : "<head>"));
        }
    }

    public static boolean isUseRegularResources() {
        return RW_LOCK.readLockedBoolean(() -> s_bUseRegularResources);
    }

    public static void setUseRegularResources(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bUseRegularResources = bl;
        });
        if (!HCSettings.isSilentMode()) {
            LOGGER.info("Default using " + (bl ? "regular" : "minified") + " resources");
        }
    }

    static {
        for (IHCSettingsProviderSPI iHCSettingsProviderSPI : ServiceLoaderHelper.getAllSPIImplementations(IHCSettingsProviderSPI.class)) {
            iHCSettingsProviderSPI.initHCSettings();
        }
    }
}

