/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.attr.IAttributeContainer;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.html.CHTMLAttributes;
import com.helger.html.hc.html.IHCElement;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroQName;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IHCAttrContainer
extends IAttributeContainer<IMicroQName, String> {
    @Nonnull
    default public EChange putIn(@Nonnull String string, @Nullable String string2) {
        return this.putIn(new MicroQName(string), string2);
    }

    default public boolean hasDataAttrs() {
        return CollectionHelper.containsAny((Iterable)this.keySet(), iMicroQName -> CHTMLAttributes.isDataAttrName(iMicroQName.getName()));
    }

    default public boolean containsDataAttr(@Nullable String string) {
        return this.containsKey(CHTMLAttributes.makeDataAttrName(string));
    }

    @Nullable
    default public String getDataAttrValue(@Nullable String string) {
        return (String)this.getValue(CHTMLAttributes.makeDataAttrName(string));
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsOrderedMap<IMicroQName, String> getAllDataAttrs() {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (Map.Entry entry : this.entrySet()) {
            if (!CHTMLAttributes.isDataAttrName(((IMicroQName)entry.getKey()).getName())) continue;
            commonsLinkedHashMap.put((Object)((IMicroQName)entry.getKey()), (Object)((String)entry.getValue()));
        }
        return commonsLinkedHashMap;
    }

    @Nonnull
    default public EChange setDataAttr(@Nullable String string, int n) {
        return this.setDataAttr(string, Integer.toString(n));
    }

    @Nonnull
    default public EChange setDataAttr(@Nullable String string, long l) {
        return this.setDataAttr(string, Long.toString(l));
    }

    @Nonnull
    default public EChange setDataAttr(@Nullable String string, @Nullable String string2) {
        return this.putIn(CHTMLAttributes.makeDataAttrName(string), string2);
    }

    @Nonnull
    default public EChange removeDataAttr(@Nullable String string) {
        return this.removeObject(CHTMLAttributes.makeDataAttrName(string));
    }

    @Nonnull
    default public EChange setAriaControls(@Nonnull String string) {
        return this.putIn(CHTMLAttributes.ARIA_CONTROLS, string);
    }

    @Nonnull
    default public EChange setAriaDescribedBy(@Nonnull String string) {
        return this.putIn(CHTMLAttributes.ARIA_DESCRIBEDBY, string);
    }

    @Nonnull
    default public EChange addToAriaDescribedBy(@Nonnull String string) {
        String string2 = (String)this.getValue(CHTMLAttributes.ARIA_DESCRIBEDBY);
        return this.setAriaDescribedBy((String)(StringHelper.hasText((String)string2) ? string2 + " " + string : string));
    }

    @Nonnull
    default public EChange setAriaDescribedBy(@Nonnull IHCElement<?> iHCElement) {
        return this.setAriaDescribedBy(((IHCElement)iHCElement.ensureID()).getID());
    }

    @Nonnull
    default public EChange addToAriaDescribedBy(@Nonnull IHCElement<?> iHCElement) {
        return this.addToAriaDescribedBy(((IHCElement)iHCElement.ensureID()).getID());
    }

    @Nonnull
    default public EChange setAriaDescribedBy(@Nonnull Iterable<? extends IHCElement<?>> iterable) {
        return this.setAriaDescribedBy(StringHelper.imploder().source(iterable, iHCElement -> ((IHCElement)iHCElement.ensureID()).getID()).separator(' ').build());
    }

    @Nonnull
    default public EChange addToAriaDescribedBy(@Nonnull Iterable<? extends IHCElement<?>> iterable) {
        return this.addToAriaDescribedBy(StringHelper.imploder().source(iterable, iHCElement -> ((IHCElement)iHCElement.ensureID()).getID()).separator(' ').build());
    }

    @Nonnull
    default public EChange setAriaDescribedBy(IHCElement<?> ... iHCElementArray) {
        return this.setAriaDescribedBy(StringHelper.imploder().source((Object[])iHCElementArray, iHCElement -> ((IHCElement)iHCElement.ensureID()).getID()).separator(' ').build());
    }

    @Nonnull
    default public EChange addToAriaDescribedBy(IHCElement<?> ... iHCElementArray) {
        return this.addToAriaDescribedBy(StringHelper.imploder().source((Object[])iHCElementArray, iHCElement -> ((IHCElement)iHCElement.ensureID()).getID()).separator(' ').build());
    }

    @Nonnull
    default public EChange setAriaExpanded(boolean bl) {
        return this.putIn(CHTMLAttributes.ARIA_EXPANDED, Boolean.toString(bl));
    }

    @Nonnull
    default public EChange setAriaHasPopup(boolean bl) {
        return this.putIn(CHTMLAttributes.ARIA_HASPOPUP, Boolean.toString(bl));
    }

    @Nonnull
    default public EChange setAriaHidden(boolean bl) {
        return this.putIn(CHTMLAttributes.ARIA_HIDDEN, Boolean.toString(bl));
    }

    @Nonnull
    default public EChange setAriaInvalid(boolean bl) {
        return this.putIn(CHTMLAttributes.ARIA_INVALID, Boolean.toString(bl));
    }

    @Nonnull
    default public EChange setAriaLabel(@Nonnull String string) {
        return this.putIn(CHTMLAttributes.ARIA_LABEL, string);
    }

    @Nonnull
    default public EChange setAriaLabeledBy(@Nonnull String string) {
        return this.putIn(CHTMLAttributes.ARIA_LABELLEDBY, string);
    }

    @Nonnull
    default public EChange setAriaLabeledBy(@Nonnull IHCElement<?> iHCElement) {
        return this.setAriaLabeledBy(((IHCElement)iHCElement.ensureID()).getID());
    }

    @Nonnull
    default public EChange setAriaLabeledBy(@Nonnull Iterable<? extends IHCElement<?>> iterable) {
        return this.setAriaLabeledBy(StringHelper.imploder().source(iterable, iHCElement -> ((IHCElement)iHCElement.ensureID()).getID()).separator(' ').build());
    }

    @Nonnull
    default public EChange setAriaLabeledBy(IHCElement<?> ... iHCElementArray) {
        return this.setAriaLabeledBy(StringHelper.imploder().source((Object[])iHCElementArray, iHCElement -> ((IHCElement)iHCElement.ensureID()).getID()).separator(' ').build());
    }

    @Nonnull
    default public EChange setAriaRequired(boolean bl) {
        return this.putIn(CHTMLAttributes.ARIA_REQUIRED, Boolean.toString(bl));
    }
}

