/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.forms;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.string.StringHelper;
import com.helger.html.hc.html.IHCHasHTMLAttributeValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EHCInputType implements IHCHasHTMLAttributeValue
{
    HIDDEN("hidden", false),
    TEXT("text", true),
    SEARCH("search", true),
    TEL("tel", true),
    URL("url", true),
    EMAIL("email", true),
    PASSWORD("password", true),
    DATE("date", true),
    TIME("time", true),
    NUMBER("number", true),
    RANGE("range", false),
    COLOR("color", true),
    CHECKBOX("checkbox", false),
    RADIO("radio", false),
    FILE("file", true),
    SUBMIT("submit", false),
    IMAGE("image", false),
    RESET("reset", false),
    BUTTON("button", false);

    private final String m_sAttrValue;
    private final boolean m_bHasPlaceholder;

    private EHCInputType(String string2, boolean bl) {
        this.m_sAttrValue = string2;
        this.m_bHasPlaceholder = bl;
    }

    @Nonnull
    @Nonempty
    public String getAttrValue() {
        return this.m_sAttrValue;
    }

    public boolean hasPlaceholder() {
        return this.m_bHasPlaceholder;
    }

    @Nullable
    public static EHCInputType getFromAttrValueOrNull(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        return (EHCInputType)EnumHelper.findFirst(EHCInputType.class, eHCInputType -> eHCInputType.getAttrValue().equals(string));
    }
}

