/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.forms;

import com.helger.commons.string.ToStringGenerator;
import com.helger.html.CHTMLAttributeValues;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.html.AbstractHCElementWithInternalChildren;
import com.helger.html.hc.html.IHCHasState;
import com.helger.html.hc.impl.HCTextNode;
import com.helger.xml.microdom.IMicroElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HCOption
extends AbstractHCElementWithInternalChildren<HCOption, HCTextNode>
implements IHCHasState<HCOption> {
    public static final boolean DEFAULT_DISABLED = false;
    public static final boolean DEFAULT_SELECTED = false;
    private boolean m_bDisabled = false;
    private String m_sLabel;
    private boolean m_bSelected = false;
    private String m_sValue;
    private boolean m_bSelectionDefined = false;

    public HCOption() {
        super(EHTMLElement.OPTION);
    }

    @Override
    public final boolean isDisabled() {
        return this.m_bDisabled;
    }

    @Override
    @Nonnull
    public final HCOption setDisabled(boolean bl) {
        this.m_bDisabled = bl;
        return this;
    }

    @Nullable
    public final String getLabel() {
        return this.m_sLabel;
    }

    @Nonnull
    public final HCOption setLabel(String string) {
        this.m_sLabel = string;
        return this;
    }

    public final boolean isSelected() {
        return this.m_bSelected;
    }

    public final boolean isSelectionDefined() {
        return this.m_bSelectionDefined;
    }

    @Nonnull
    public final HCOption setSelected(boolean bl) {
        this.m_bSelected = bl;
        this.m_bSelectionDefined = true;
        return this;
    }

    @Nullable
    public final String getValue() {
        return this.m_sValue;
    }

    @Nonnull
    public final HCOption setValue(@Nullable String string) {
        this.m_sValue = string;
        return this;
    }

    @Override
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (this.m_bDisabled) {
            iMicroElement.setAttribute(CHTMLAttributes.DISABLED, CHTMLAttributeValues.DISABLED);
        }
        if (this.m_sLabel != null) {
            iMicroElement.setAttribute(CHTMLAttributes.LABEL, this.m_sLabel);
        }
        if (this.m_bSelected) {
            iMicroElement.setAttribute(CHTMLAttributes.SELECTED, CHTMLAttributeValues.SELECTED);
        }
        if (this.m_sValue != null) {
            iMicroElement.setAttribute(CHTMLAttributes.VALUE, this.m_sValue);
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("disabled", this.m_bDisabled).appendIfNotNull("label", (Object)this.m_sLabel).append("selected", this.m_bSelected).appendIfNotNull("value", (Object)this.m_sValue).getToString();
    }
}

