/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.script;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.html.AbstractHCElement;
import com.helger.html.hc.html.embedded.EHCCORSSettings;
import com.helger.html.hc.html.script.IHCScript;
import com.helger.xml.microdom.IHasAttributeValue;
import com.helger.xml.microdom.IMicroElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractHCScript<IMPLTYPE extends AbstractHCScript<IMPLTYPE>>
extends AbstractHCElement<IMPLTYPE>
implements IHCScript<IMPLTYPE> {
    public static final IMimeType DEFAULT_TYPE = CMimeType.TEXT_JAVASCRIPT;
    private IMimeType m_aType = DEFAULT_TYPE;
    private String m_sCharset;
    private EHCCORSSettings m_eCrossOrigin;
    private String m_sIntegrity;

    protected AbstractHCScript() {
        super(EHTMLElement.SCRIPT);
    }

    @Override
    @Nonnull
    public final IMimeType getType() {
        return this.m_aType;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setType(@Nonnull IMimeType iMimeType) {
        this.m_aType = (IMimeType)ValueEnforcer.notNull((Object)iMimeType, (String)"Type");
        return (IMPLTYPE)((AbstractHCScript)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getCharset() {
        return this.m_sCharset;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setCharset(@Nullable String string) {
        this.m_sCharset = string;
        return (IMPLTYPE)((AbstractHCScript)this.thisAsT());
    }

    @Override
    @Nullable
    public final EHCCORSSettings getCrossOrigin() {
        return this.m_eCrossOrigin;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setCrossOrigin(@Nullable EHCCORSSettings eHCCORSSettings) {
        this.m_eCrossOrigin = eHCCORSSettings;
        return (IMPLTYPE)((AbstractHCScript)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getIntegrity() {
        return this.m_sIntegrity;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setIntegrity(@Nullable String string) {
        this.m_sIntegrity = string;
        return (IMPLTYPE)((AbstractHCScript)this.thisAsT());
    }

    @Override
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        iMicroElement.setAttribute(CHTMLAttributes.TYPE, this.m_aType.getAsString());
        if (StringHelper.hasText((String)this.m_sCharset)) {
            iMicroElement.setAttribute(CHTMLAttributes.CHARSET, this.m_sCharset);
        }
        if (this.m_eCrossOrigin != null) {
            iMicroElement.setAttribute(CHTMLAttributes.CROSSORIGIN, (IHasAttributeValue)this.m_eCrossOrigin);
        }
        if (StringHelper.hasText((String)this.m_sIntegrity)) {
            iMicroElement.setAttribute(CHTMLAttributes.INTEGRITY, this.m_sIntegrity);
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIfNotNull("Type", (Object)this.m_aType).appendIfNotNull("Charset", (Object)this.m_sCharset).appendIfNotNull("CrossOrigin", (Object)this.m_eCrossOrigin).appendIfNotNull("Integrity", (Object)this.m_sIntegrity).getToString();
    }
}

