/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.tabular;

import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.AbstractHCElementWithInternalChildren;
import com.helger.html.hc.html.tabular.AbstractHCCell;
import com.helger.html.hc.html.tabular.HCTD;
import com.helger.html.hc.html.tabular.HCTH;
import com.helger.html.hc.html.tabular.IHCCell;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HCRow
extends AbstractHCElementWithInternalChildren<HCRow, IHCCell<?>> {
    private final boolean m_bHeader;

    @DevelopersNote(value="Works only for tbody rows!")
    public HCRow() {
        this(false);
    }

    public HCRow(boolean bl) {
        super(EHTMLElement.TR);
        this.m_bHeader = bl;
    }

    public final boolean isHeader() {
        return this.m_bHeader;
    }

    @Nonnull
    public final IHCCell<?> addCell() {
        AbstractHCCell abstractHCCell = this.m_bHeader ? new HCTH() : new HCTD();
        abstractHCCell.internalSetParentRow(this);
        this.addChild(abstractHCCell);
        return abstractHCCell;
    }

    @Nonnull
    public final IHCCell<?> addCellAt(@Nonnegative int n) {
        AbstractHCCell abstractHCCell = this.m_bHeader ? new HCTH() : new HCTD();
        abstractHCCell.internalSetParentRow(this);
        this.addChildAt(n, abstractHCCell);
        return abstractHCCell;
    }

    @Nonnull
    @CheckReturnValue
    public final IHCCell<?> addAndReturnCell(@Nullable String string) {
        return (IHCCell)this.addCell().addChild(string);
    }

    @Nonnull
    @CheckReturnValue
    public final IHCCell<?> addAndReturnCell(@Nullable IHCNode iHCNode) {
        return (IHCCell)this.addCell().addChild(iHCNode);
    }

    @Nonnull
    @CheckReturnValue
    public final IHCCell<?> addAndReturnCell(String ... stringArray) {
        return (IHCCell)this.addCell().addChildren(stringArray);
    }

    @Nonnull
    @CheckReturnValue
    public final IHCCell<?> addAndReturnCell(IHCNode ... iHCNodeArray) {
        return (IHCCell)this.addCell().addChildren(iHCNodeArray);
    }

    @Nonnull
    @CheckReturnValue
    public final IHCCell<?> addAndReturnCell(@Nullable Iterable<? extends IHCNode> iterable) {
        return (IHCCell)this.addCell().addChildren(iterable);
    }

    @Nonnull
    @CheckReturnValue
    public final IHCCell<?> addAndReturnCellAt(@Nonnegative int n, @Nullable String string) {
        return (IHCCell)this.addCellAt(n).addChild(string);
    }

    @Nonnull
    @CheckReturnValue
    public final IHCCell<?> addAndReturnCellAt(@Nonnegative int n, @Nullable IHCNode iHCNode) {
        return (IHCCell)this.addCellAt(n).addChild(iHCNode);
    }

    @Nonnull
    @CheckReturnValue
    public final IHCCell<?> addAndReturnCellAt(@Nonnegative int n, String ... stringArray) {
        return (IHCCell)this.addCellAt(n).addChildren(stringArray);
    }

    @Nonnull
    @CheckReturnValue
    public final IHCCell<?> addAndReturnCellAt(@Nonnegative int n, IHCNode ... iHCNodeArray) {
        return (IHCCell)this.addCellAt(n).addChildren(iHCNodeArray);
    }

    @Nonnull
    @CheckReturnValue
    public final IHCCell<?> addAndReturnCellAt(@Nonnegative int n, @Nullable Iterable<? extends IHCNode> iterable) {
        return (IHCCell)this.addCellAt(n).addChildren(iterable);
    }

    @Nonnull
    public final HCRow addCell(@Nullable String string) {
        this.addCell().addChild(string);
        return this;
    }

    @Nonnull
    public final HCRow addCell(@Nullable IHCNode iHCNode) {
        this.addCell().addChild(iHCNode);
        return this;
    }

    @Nonnull
    public final HCRow addCell(String ... stringArray) {
        this.addCell().addChildren(stringArray);
        return this;
    }

    @Nonnull
    public final HCRow addCell(IHCNode ... iHCNodeArray) {
        this.addCell().addChildren(iHCNodeArray);
        return this;
    }

    @Nonnull
    public final HCRow addCell(@Nullable Iterable<? extends IHCNode> iterable) {
        this.addCell().addChildren(iterable);
        return this;
    }

    @Nonnull
    public final HCRow addCellAt(@Nonnegative int n, @Nullable String string) {
        this.addCellAt(n).addChild(string);
        return this;
    }

    @Nonnull
    public final HCRow addCellAt(@Nonnegative int n, @Nullable IHCNode iHCNode) {
        this.addCellAt(n).addChild(iHCNode);
        return this;
    }

    @Nonnull
    public final HCRow addCellAt(@Nonnegative int n, String ... stringArray) {
        this.addCellAt(n).addChildren(stringArray);
        return this;
    }

    @Nonnull
    public final HCRow addCellAt(@Nonnegative int n, IHCNode ... iHCNodeArray) {
        this.addCellAt(n).addChildren(iHCNodeArray);
        return this;
    }

    @Nonnull
    public final HCRow addCellAt(@Nonnegative int n, @Nullable Iterable<? extends IHCNode> iterable) {
        this.addCellAt(n).addChildren(iterable);
        return this;
    }

    @Deprecated(forRemoval=false)
    @Nonnull
    @DevelopersNote(value="Use addCell")
    public final HCRow addCells(@Nullable String string) {
        return this.addCell(string);
    }

    @Nonnull
    public final HCRow addCells(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                this.addCell(string);
            }
        }
        return this;
    }

    @Deprecated(forRemoval=false)
    @Nonnull
    @DevelopersNote(value="Use addCell")
    public final HCRow addCells(@Nullable IHCNode iHCNode) {
        return this.addCell(iHCNode);
    }

    @Nonnull
    public final HCRow addCells(IHCNode ... iHCNodeArray) {
        if (iHCNodeArray != null) {
            for (IHCNode iHCNode : iHCNodeArray) {
                this.addCell(iHCNode);
            }
        }
        return this;
    }

    @Nonnull
    public final HCRow addCells(@Nullable Iterable<? extends IHCNode> iterable) {
        if (iterable != null) {
            for (IHCNode iHCNode : iterable) {
                this.addCell(iHCNode);
            }
        }
        return this;
    }

    @Nullable
    public final IHCCell<?> getCellAtIndex(int n) {
        return (IHCCell)this.getChildAtIndex(n);
    }

    @Nullable
    public final IHCCell<?> getCellAtEffectiveIndex(int n) {
        int n2 = 0;
        if (this.hasChildren()) {
            for (IHCCell iHCCell : this.children()) {
                if (n2 >= n) {
                    return iHCCell;
                }
                n2 += iHCCell.getColspan();
            }
        }
        return null;
    }

    @Nonnegative
    public final int getCellCount() {
        return this.getChildCount();
    }

    @Nonnegative
    public final int getEffectiveCellCount() {
        int n = 0;
        if (this.hasChildren()) {
            for (IHCCell iHCCell : this.children()) {
                n += iHCCell.getColspan();
            }
        }
        return n;
    }

    @Nonnull
    public final HCRow removeCellAt(@Nonnegative int n) {
        this.removeChildAt(n);
        return this;
    }

    public final boolean isColspanUsed() {
        if (this.hasChildren()) {
            for (IHCCell iHCCell : this.children()) {
                if (iHCCell.getColspan() <= 1) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isRowspanUsed() {
        if (this.hasChildren()) {
            for (IHCCell iHCCell : this.children()) {
                if (iHCCell.getRowspan() <= 1) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canConvertToMicroNode(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        return this.hasChildren();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("header", this.m_bHeader).getToString();
    }
}

