/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.meta;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.meta.EMetaElementType;
import com.helger.html.meta.IMetaElementValue;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MetaElementValue
implements IMetaElementValue {
    private final EMetaElementType m_eType;
    private final String m_sName;
    private final Locale m_aContentLocale;
    private final String m_sContent;

    public MetaElementValue(@Nonnull EMetaElementType eMetaElementType, @Nonnull String string, @Nonnull Locale locale, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)((Object)eMetaElementType), (String)"Type");
        ValueEnforcer.notNull((Object)string, (String)"Name");
        ValueEnforcer.notNull((Object)locale, (String)"ContentLocale");
        ValueEnforcer.notNull((Object)string2, (String)"Content");
        this.m_eType = eMetaElementType;
        this.m_sName = string;
        this.m_aContentLocale = locale;
        this.m_sContent = string2;
    }

    @Override
    @Nonnull
    public EMetaElementType getType() {
        return this.m_eType;
    }

    @Nonnull
    public String getName() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    public Locale getContentLocale() {
        return this.m_aContentLocale;
    }

    @Override
    @Nonnull
    public String getContent() {
        return this.m_sContent;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MetaElementValue metaElementValue = (MetaElementValue)object;
        return this.m_eType.equals((Object)metaElementValue.m_eType) && this.m_sName.equals(metaElementValue.m_sName) && this.m_aContentLocale.equals(metaElementValue.m_aContentLocale) && this.m_sContent.equals(metaElementValue.m_sContent);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eType).append((Object)this.m_sName).append((Object)this.m_aContentLocale).append((Object)this.m_sContent).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("type", (Enum)this.m_eType).append("name", (Object)this.m_sName).append("contentLocale", (Object)this.m_aContentLocale).append("content", (Object)this.m_sContent).getToString();
    }
}

