/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.embedded;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.ISimpleURL;
import com.helger.css.ECSSUnit;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.html.AbstractHCElementWithChildren;
import com.helger.html.hc.html.EHCScrolling;
import com.helger.html.hc.html.embedded.EHCIFrameAlign;
import com.helger.html.hc.html.embedded.EHCLoadingType;
import com.helger.html.hc.html.embedded.EHCSandboxAllow;
import com.helger.html.hc.html.embedded.IHCIFrame;
import com.helger.xml.microdom.IHasAttributeValue;
import com.helger.xml.microdom.IMicroElement;
import java.util.Collections;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractHCIFrame<IMPLTYPE extends AbstractHCIFrame<IMPLTYPE>>
extends AbstractHCElementWithChildren<IMPLTYPE>
implements IHCIFrame<IMPLTYPE> {
    public static final EHCScrolling DEFAULT_SCROLLING = EHCScrolling.AUTO;
    public static final boolean DEFAULT_FRAME_BORDER = true;
    public static final boolean DEFAULT_SANDBOX = false;
    private ISimpleURL m_aSrc;
    private String m_sName;
    private String m_sLongDesc;
    private EHCScrolling m_eScrolling = DEFAULT_SCROLLING;
    private EHCIFrameAlign m_eAlign;
    private boolean m_bFrameBorder = true;
    private String m_sWidth;
    private String m_sHeight;
    private int m_nMarginWidth = -1;
    private int m_nMarginHeight = -1;
    private boolean m_bSandbox = false;
    private final EnumSet<EHCSandboxAllow> m_aSandboxAllows = EnumSet.noneOf(EHCSandboxAllow.class);
    private EHCLoadingType m_eLoading;

    public AbstractHCIFrame() {
        super(EHTMLElement.IFRAME);
    }

    @Override
    @Nullable
    public final ISimpleURL getSrc() {
        return this.m_aSrc;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setSrc(@Nullable ISimpleURL iSimpleURL) {
        this.m_aSrc = iSimpleURL;
        return (IMPLTYPE)((AbstractHCIFrame)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getName() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setName(@Nullable String string) {
        this.m_sName = string;
        return (IMPLTYPE)((AbstractHCIFrame)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getLongDesc() {
        return this.m_sLongDesc;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setLongDesc(@Nullable String string) {
        this.m_sLongDesc = string;
        return (IMPLTYPE)((AbstractHCIFrame)this.thisAsT());
    }

    @Override
    @Nullable
    public final EHCScrolling getScrolling() {
        return this.m_eScrolling;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setScrolling(@Nullable EHCScrolling eHCScrolling) {
        this.m_eScrolling = eHCScrolling;
        return (IMPLTYPE)((AbstractHCIFrame)this.thisAsT());
    }

    @Override
    @Nullable
    public final EHCIFrameAlign getAlign() {
        return this.m_eAlign;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setAlign(@Nullable EHCIFrameAlign eHCIFrameAlign) {
        this.m_eAlign = eHCIFrameAlign;
        return (IMPLTYPE)((AbstractHCIFrame)this.thisAsT());
    }

    @Override
    public final boolean isFrameBorder() {
        return this.m_bFrameBorder;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setFrameBorder(boolean bl) {
        this.m_bFrameBorder = bl;
        return (IMPLTYPE)((AbstractHCIFrame)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getWidth() {
        return this.m_sWidth;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setWidth(int n) {
        if (n >= 0) {
            this.m_sWidth = Integer.toString(n);
        }
        return (IMPLTYPE)((AbstractHCIFrame)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE setWidthPercentage(double d) {
        this.m_sWidth = ECSSUnit.perc((double)d);
        return (IMPLTYPE)((AbstractHCIFrame)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getHeight() {
        return this.m_sHeight;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setHeight(int n) {
        if (n >= 0) {
            this.m_sHeight = Integer.toString(n);
        }
        return (IMPLTYPE)((AbstractHCIFrame)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE setHeightPercentage(double d) {
        this.m_sHeight = ECSSUnit.perc((double)d);
        return (IMPLTYPE)((AbstractHCIFrame)this.thisAsT());
    }

    @Override
    public final int getMarginWidth() {
        return this.m_nMarginWidth;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setMarginWidth(int n) {
        this.m_nMarginWidth = n;
        return (IMPLTYPE)((AbstractHCIFrame)this.thisAsT());
    }

    @Override
    public final int getMarginHeight() {
        return this.m_nMarginHeight;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setMarginHeight(int n) {
        this.m_nMarginHeight = n;
        return (IMPLTYPE)((AbstractHCIFrame)this.thisAsT());
    }

    @Override
    public final boolean isSandbox() {
        return this.m_bSandbox;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final EnumSet<EHCSandboxAllow> getSandboxAllow() {
        return EnumSet.copyOf(this.m_aSandboxAllows);
    }

    @Override
    @Nonnull
    public final IMPLTYPE setSandbox(boolean bl, EHCSandboxAllow ... eHCSandboxAllowArray) {
        this.m_bSandbox = bl;
        this.m_aSandboxAllows.clear();
        if (eHCSandboxAllowArray != null) {
            Collections.addAll(this.m_aSandboxAllows, eHCSandboxAllowArray);
        }
        return (IMPLTYPE)((AbstractHCIFrame)this.thisAsT());
    }

    @Nullable
    public final EHCLoadingType getLoading() {
        return this.m_eLoading;
    }

    @Nonnull
    public final IMPLTYPE setLoading(@Nullable EHCLoadingType eHCLoadingType) {
        this.m_eLoading = eHCLoadingType;
        return (IMPLTYPE)((AbstractHCIFrame)this.thisAsT());
    }

    @Override
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (this.m_aSrc != null) {
            iMicroElement.setAttribute(CHTMLAttributes.SRC, this.m_aSrc.getAsStringWithEncodedParameters(iHCConversionSettingsToNode.getCharset()));
        }
        if (StringHelper.hasText((String)this.m_sName)) {
            iMicroElement.setAttribute(CHTMLAttributes.NAME, this.m_sName);
        }
        if (StringHelper.hasText((String)this.m_sLongDesc)) {
            iMicroElement.setAttribute(CHTMLAttributes.LONGDESC, this.m_sLongDesc);
        }
        if (this.m_eScrolling != null) {
            iMicroElement.setAttribute(CHTMLAttributes.SCROLLING, (IHasAttributeValue)this.m_eScrolling);
        }
        if (this.m_eAlign != null) {
            iMicroElement.setAttribute(CHTMLAttributes.ALIGN, (IHasAttributeValue)this.m_eAlign);
        }
        iMicroElement.setAttribute(CHTMLAttributes.FRAMEBORDER, this.m_bFrameBorder ? "1" : "0");
        if (StringHelper.hasText((String)this.m_sWidth)) {
            iMicroElement.setAttribute(CHTMLAttributes.WIDTH, this.m_sWidth);
        }
        if (StringHelper.hasText((String)this.m_sHeight)) {
            iMicroElement.setAttribute(CHTMLAttributes.HEIGHT, this.m_sHeight);
        }
        if (this.m_nMarginWidth >= 0) {
            iMicroElement.setAttribute(CHTMLAttributes.MARGINWIDTH, this.m_nMarginWidth);
        }
        if (this.m_nMarginHeight >= 0) {
            iMicroElement.setAttribute(CHTMLAttributes.MARGINHEIGHT, this.m_nMarginHeight);
        }
        if (this.m_bSandbox) {
            StringBuilder stringBuilder = new StringBuilder();
            for (EHCSandboxAllow eHCSandboxAllow : this.m_aSandboxAllows) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(eHCSandboxAllow.getAttrValue());
            }
            iMicroElement.setAttribute(CHTMLAttributes.SANDBOX, stringBuilder.toString());
        }
        if (this.m_eLoading != null) {
            iMicroElement.setAttribute(CHTMLAttributes.LOADING, (IHasAttributeValue)this.m_eLoading);
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIfNotNull("Src", (Object)this.m_aSrc).appendIfNotNull("Name", (Object)this.m_sName).appendIfNotNull("LongDesc", (Object)this.m_sLongDesc).appendIfNotNull("Scrolling", (Object)this.m_eScrolling).appendIfNotNull("Align", (Object)this.m_eAlign).append("FrameBorder", this.m_bFrameBorder).appendIfNotNull("Width", (Object)this.m_sWidth).appendIfNotNull("Height", (Object)this.m_sHeight).append("MarginWidth", this.m_nMarginWidth).append("MarginHeight", this.m_nMarginHeight).appendIfNotNull("Loading", (Object)this.m_eLoading).getToString();
    }
}

