/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.embedded;

import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.ISimpleURL;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.html.AbstractHCMediaElementChild;
import com.helger.html.hc.html.IHCHasMedia;
import com.helger.xml.microdom.IMicroElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HCSource
extends AbstractHCMediaElementChild<HCSource>
implements IHCHasMedia<HCSource> {
    private ISimpleURL m_aSrc;
    private IMimeType m_aType;
    private String m_sSrcSet;
    private String m_sSizes;
    private String m_sMediaQuery;

    public HCSource() {
        super(EHTMLElement.SOURCE);
    }

    @Nullable
    public final ISimpleURL getSrc() {
        return this.m_aSrc;
    }

    @Nonnull
    public final HCSource setSrc(@Nullable ISimpleURL iSimpleURL) {
        this.m_aSrc = iSimpleURL;
        return this;
    }

    @Nullable
    public final IMimeType getType() {
        return this.m_aType;
    }

    @Nonnull
    public final HCSource setType(@Nullable IMimeType iMimeType) {
        this.m_aType = iMimeType;
        return this;
    }

    @Nullable
    public final String getSrcSet() {
        return this.m_sSrcSet;
    }

    @Nonnull
    public final HCSource setSrcSet(@Nullable String string) {
        this.m_sSrcSet = string;
        return this;
    }

    @Nullable
    public final String getSizes() {
        return this.m_sSizes;
    }

    @Nonnull
    public final HCSource setSizes(@Nullable String string) {
        this.m_sSizes = string;
        return this;
    }

    @Override
    @Nullable
    public final String getMedia() {
        return this.m_sMediaQuery;
    }

    @Override
    @Nonnull
    public final HCSource setMedia(@Nullable String string) {
        this.m_sMediaQuery = string;
        return this;
    }

    @Override
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (this.m_aSrc != null) {
            iMicroElement.setAttribute(CHTMLAttributes.SRC, this.m_aSrc.getAsStringWithEncodedParameters(iHCConversionSettingsToNode.getCharset()));
        }
        if (this.m_aType != null) {
            iMicroElement.setAttribute(CHTMLAttributes.TYPE, this.m_aType.getAsString());
        }
        if (StringHelper.hasText((String)this.m_sSrcSet)) {
            iMicroElement.setAttribute(CHTMLAttributes.SRCSET, this.m_sSrcSet);
        }
        if (StringHelper.hasText((String)this.m_sSizes)) {
            iMicroElement.setAttribute(CHTMLAttributes.SIZES, this.m_sSizes);
        }
        if (StringHelper.hasText((String)this.m_sMediaQuery)) {
            iMicroElement.setAttribute(CHTMLAttributes.MEDIA, this.m_sMediaQuery);
        }
    }
}

