/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.forms;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.ISimpleURL;
import com.helger.html.CHTMLAttributeValues;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.config.HCConsistencyChecker;
import com.helger.html.hc.html.AbstractHCElementWithChildren;
import com.helger.html.hc.html.HCHTMLHelper;
import com.helger.html.hc.html.HC_Action;
import com.helger.html.hc.html.HC_Target;
import com.helger.html.hc.html.IHCElement;
import com.helger.html.hc.html.forms.EHCButtonType;
import com.helger.html.hc.html.forms.EHCFormMethod;
import com.helger.html.hc.html.forms.IHCButton;
import com.helger.html.js.IHasJSCode;
import com.helger.html.js.IHasJSCodeWithSettings;
import com.helger.xml.microdom.IHasAttributeValue;
import com.helger.xml.microdom.IMicroElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractHCButton<IMPLTYPE extends AbstractHCButton<IMPLTYPE>>
extends AbstractHCElementWithChildren<IMPLTYPE>
implements IHCButton<IMPLTYPE> {
    public static final boolean DEFAULT_AUTO_FOCUS = false;
    public static final boolean DEFAULT_DISABLED = false;
    public static final boolean DEFAULT_FORMNOVALIDATE = false;
    private boolean m_bAutoFocus = false;
    private boolean m_bDisabled = false;
    private String m_sForm;
    private final HC_Action m_aFormAction = new HC_Action();
    private IMimeType m_aFormEncType;
    private EHCFormMethod m_eFormMethod;
    private boolean m_bFormNoValidate = false;
    private HC_Target m_aFormTarget;
    private String m_sName;
    private EHCButtonType m_eType = EHCButtonType.BUTTON;
    private String m_sValue;

    public AbstractHCButton() {
        super(EHTMLElement.BUTTON);
    }

    public AbstractHCButton(@Nullable String string) {
        this();
        this.addChild(string);
    }

    public AbstractHCButton(@Nullable String string, @Nullable IHasJSCode iHasJSCode) {
        this(string);
        this.setOnClick(iHasJSCode);
    }

    @Override
    public final boolean isAutoFocus() {
        return this.m_bAutoFocus;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setAutoFocus(boolean bl) {
        this.m_bAutoFocus = bl;
        return (IMPLTYPE)((AbstractHCButton)this.thisAsT());
    }

    @Override
    public final boolean isDisabled() {
        return this.m_bDisabled;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setDisabled(boolean bl) {
        this.m_bDisabled = bl;
        return (IMPLTYPE)((AbstractHCButton)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getForm() {
        return this.m_sForm;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setForm(@Nullable String string) {
        this.m_sForm = string;
        return (IMPLTYPE)((AbstractHCButton)this.thisAsT());
    }

    @Override
    @Nullable
    public final ISimpleURL getFormActionURL() {
        return this.m_aFormAction.getActionURL();
    }

    @Override
    @Nullable
    public final IHasJSCode getFormActionJS() {
        return this.m_aFormAction.getActionJS();
    }

    @Override
    @Nonnull
    public final IMPLTYPE setFormAction(@Nullable ISimpleURL iSimpleURL) {
        this.m_aFormAction.setAction(iSimpleURL);
        return (IMPLTYPE)((AbstractHCButton)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE setFormAction(@Nullable IHasJSCodeWithSettings iHasJSCodeWithSettings) {
        this.m_aFormAction.setAction(iHasJSCodeWithSettings);
        return (IMPLTYPE)((AbstractHCButton)this.thisAsT());
    }

    @Override
    @Nullable
    public final IMimeType getFormEncType() {
        return this.m_aFormEncType;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setFormEncType(@Nullable IMimeType iMimeType) {
        this.m_aFormEncType = iMimeType;
        return (IMPLTYPE)((AbstractHCButton)this.thisAsT());
    }

    @Override
    @Nullable
    public final EHCFormMethod getFormMethod() {
        return this.m_eFormMethod;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setFormMethod(@Nullable EHCFormMethod eHCFormMethod) {
        this.m_eFormMethod = eHCFormMethod;
        return (IMPLTYPE)((AbstractHCButton)this.thisAsT());
    }

    @Override
    public final boolean isFormNoValidate() {
        return this.m_bFormNoValidate;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setFormNoValidate(boolean bl) {
        this.m_bFormNoValidate = bl;
        return (IMPLTYPE)((AbstractHCButton)this.thisAsT());
    }

    @Override
    @Nullable
    public final HC_Target getFormTarget() {
        return this.m_aFormTarget;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setFormTarget(@Nullable HC_Target hC_Target) {
        this.m_aFormTarget = hC_Target;
        return (IMPLTYPE)((AbstractHCButton)this.thisAsT());
    }

    @Override
    public final String getName() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setName(@Nullable String string) {
        this.m_sName = string;
        return (IMPLTYPE)((AbstractHCButton)this.thisAsT());
    }

    @Override
    @Nonnull
    public final EHCButtonType getType() {
        return this.m_eType;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setType(@Nonnull EHCButtonType eHCButtonType) {
        this.m_eType = (EHCButtonType)ValueEnforcer.notNull((Object)eHCButtonType, (String)"Type");
        return (IMPLTYPE)((AbstractHCButton)this.thisAsT());
    }

    @Override
    public final String getValue() {
        return this.m_sValue;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setValue(@Nullable String string) {
        this.m_sValue = string;
        return (IMPLTYPE)((AbstractHCButton)this.thisAsT());
    }

    @Override
    protected void onConsistencyCheck(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.onConsistencyCheck(iHCConversionSettingsToNode);
        IHCElement<?> iHCElement = HCHTMLHelper.recursiveGetFirstChildWithTagName(this, EHTMLElement.A, EHTMLElement.INPUT, EHTMLElement.SELECT, EHTMLElement.TEXTAREA, EHTMLElement.LABEL, EHTMLElement.BUTTON, EHTMLElement.FORM, EHTMLElement.FIELDSET, EHTMLElement.IFRAME);
        if (iHCElement != null) {
            HCConsistencyChecker.consistencyError("BUTTON element contains forbidden tag " + iHCElement.getElement());
        }
    }

    @Override
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (this.m_bAutoFocus) {
            iMicroElement.setAttribute(CHTMLAttributes.AUTOFOCUS, CHTMLAttributeValues.AUTOFOCUS);
        }
        if (this.m_bDisabled) {
            iMicroElement.setAttribute(CHTMLAttributes.DISABLED, CHTMLAttributeValues.DISABLED);
        }
        if (StringHelper.hasText((String)this.m_sForm)) {
            iMicroElement.setAttribute(CHTMLAttributes.FORM, this.m_sForm);
        }
        this.m_aFormAction.applyProperties(CHTMLAttributes.FORMACTION, iMicroElement, iHCConversionSettingsToNode.getJSWriterSettings(), iHCConversionSettingsToNode.getCharset());
        if (this.m_aFormEncType != null) {
            iMicroElement.setAttribute(CHTMLAttributes.FORMENCTYPE, this.m_aFormEncType.getAsString());
        }
        if (this.m_eFormMethod != null) {
            iMicroElement.setAttribute(CHTMLAttributes.FORMMETHOD, (IHasAttributeValue)this.m_eFormMethod);
        }
        if (this.m_bFormNoValidate) {
            iMicroElement.setAttribute(CHTMLAttributes.FORMNOVALIDATE, CHTMLAttributeValues.FORMNOVALIDATE);
        }
        if (this.m_aFormTarget != null) {
            iMicroElement.setAttribute(CHTMLAttributes.FORMTARGET, (IHasAttributeValue)this.m_aFormTarget);
        }
        if (StringHelper.hasText((String)this.m_sName)) {
            iMicroElement.setAttribute(CHTMLAttributes.NAME, this.m_sName);
        }
        iMicroElement.setAttribute(CHTMLAttributes.TYPE, (IHasAttributeValue)this.m_eType);
        if (StringHelper.hasText((String)this.m_sValue)) {
            iMicroElement.setAttribute(CHTMLAttributes.VALUE, this.m_sValue);
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("autoFocus", this.m_bAutoFocus).append("disabled", this.m_bDisabled).appendIfNotNull("form", (Object)this.m_sForm).append("formaction", (Object)this.m_aFormAction).appendIfNotNull("formenctype", (Object)this.m_aFormEncType).appendIfNotNull("formmethod", (Object)this.m_eFormMethod).append("formnovalidate", this.m_bFormNoValidate).appendIfNotNull("formtarget", (Object)this.m_aFormTarget).appendIfNotNull("name", (Object)this.m_sName).append("type", (Enum)this.m_eType).appendIfNotNull("value", (Object)this.m_sValue).getToString();
    }
}

