/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.forms;

import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.AbstractHCInput;
import com.helger.html.hc.html.forms.EHCInputType;
import com.helger.html.hc.html.forms.HCHiddenField;
import com.helger.html.request.IHCRequestFieldBoolean;
import com.helger.html.request.IHCRequestFieldBooleanMultiValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractHCCheckBox<IMPLTYPE extends AbstractHCCheckBox<IMPLTYPE>>
extends AbstractHCInput<IMPLTYPE> {
    public static final String DEFAULT_VALUE = Boolean.TRUE.toString();
    public static final boolean DEFAULT_EMIT_HIDDEN_FIELD = true;
    public static final String HIDDEN_FIELD_PREFIX = "__";
    private boolean m_bEmitHiddenField = true;

    public AbstractHCCheckBox() {
        super(EHCInputType.CHECKBOX);
        this.setValue(DEFAULT_VALUE);
    }

    protected AbstractHCCheckBox(@Nullable String string, boolean bl, @Nullable String string2) {
        this();
        this.setName(string);
        this.setChecked(bl);
        this.setValue(string2);
    }

    public AbstractHCCheckBox(@Nonnull IHCRequestFieldBoolean iHCRequestFieldBoolean) {
        this(iHCRequestFieldBoolean.getFieldName(), iHCRequestFieldBoolean.isChecked(), DEFAULT_VALUE);
    }

    public AbstractHCCheckBox(@Nonnull IHCRequestFieldBooleanMultiValue iHCRequestFieldBooleanMultiValue) {
        this(iHCRequestFieldBooleanMultiValue.getFieldName(), iHCRequestFieldBooleanMultiValue.isChecked(), iHCRequestFieldBooleanMultiValue.getValue());
    }

    public final boolean isEmitHiddenField() {
        return this.m_bEmitHiddenField;
    }

    @Nonnull
    public final IMPLTYPE setEmitHiddenField(boolean bl) {
        this.m_bEmitHiddenField = bl;
        return (IMPLTYPE)((AbstractHCCheckBox)this.thisAsT());
    }

    @Nullable
    public final String getHiddenFieldName() {
        String string = this.getName();
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        return HIDDEN_FIELD_PREFIX + string;
    }

    @Override
    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        String string;
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        if (this.m_bEmitHiddenField && StringHelper.hasText((String)(string = this.getHiddenFieldName()))) {
            iHCHasChildrenMutable.addChild(new HCHiddenField(string, this.getValue()));
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("emitHiddenField", this.m_bEmitHiddenField).getToString();
    }
}

