/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.forms;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsImmutableObject;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsIterable;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.CHTMLAttributeValues;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.AbstractHCControl;
import com.helger.html.hc.html.forms.HCOptGroup;
import com.helger.html.hc.html.forms.HCOption;
import com.helger.html.hc.html.forms.IHCSelect;
import com.helger.html.request.IHCRequestField;
import com.helger.html.request.IHCRequestFieldMultiValue;
import com.helger.xml.microdom.IMicroElement;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractHCSelect<IMPLTYPE extends AbstractHCSelect<IMPLTYPE>>
extends AbstractHCControl<IMPLTYPE>
implements IHCSelect<IMPLTYPE> {
    public static final boolean DEFAULT_MULTIPLE = false;
    private String m_sForm;
    private boolean m_bMultiple = false;
    private int m_nSize = -1;
    private ICommonsList<IHCNode> m_aOptions = new CommonsArrayList();
    private final ICommonsSet<String> m_aPreselectedValues = new CommonsHashSet();
    private static final Predicate<IHCNode> PRED_SELECTED_OPTION = iHCNode -> iHCNode instanceof HCOption && ((HCOption)iHCNode).isSelected();

    public AbstractHCSelect() {
        super(EHTMLElement.SELECT);
    }

    public AbstractHCSelect(@Nonnull IHCRequestField iHCRequestField) {
        this();
        this.m_aPreselectedValues.add((Object)iHCRequestField.getRequestValue());
        this.setName(iHCRequestField.getFieldName());
    }

    public AbstractHCSelect(@Nonnull IHCRequestFieldMultiValue iHCRequestFieldMultiValue) {
        this();
        this.m_aPreselectedValues.addAll(iHCRequestFieldMultiValue.getRequestValues());
        this.setMultiple(true);
        this.setName(iHCRequestFieldMultiValue.getFieldName());
    }

    @Override
    @Nullable
    public final String getForm() {
        return this.m_sForm;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setForm(@Nullable String string) {
        this.m_sForm = string;
        return (IMPLTYPE)((AbstractHCSelect)this.thisAsT());
    }

    @Override
    public final boolean isMultiple() {
        return this.m_bMultiple;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setMultiple(boolean bl) {
        this.m_bMultiple = bl;
        return (IMPLTYPE)((AbstractHCSelect)this.thisAsT());
    }

    @Override
    public final int getSize() {
        return this.m_nSize;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setSize(int n) {
        this.m_nSize = n;
        return (IMPLTYPE)((AbstractHCSelect)this.thisAsT());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsSet<String> getAllPreselectedValues() {
        return (ICommonsSet)this.m_aPreselectedValues.getClone();
    }

    @Override
    public final boolean isPreselectedValue(@Nullable String string) {
        return this.m_aPreselectedValues.contains((Object)string);
    }

    @OverrideOnDemand
    protected void onAddOption(@Nonnull HCOption hCOption) {
    }

    @Override
    @Nonnull
    public final HCOption addOption(@Nonnull HCOption hCOption) {
        ValueEnforcer.notNull((Object)hCOption, (String)"Option");
        if (!hCOption.isSelectionDefined()) {
            hCOption.setSelected(this.isPreselectedValue(hCOption.getValue()));
        }
        this.onAddOption(hCOption);
        this.m_aOptions.add((Object)hCOption);
        return hCOption;
    }

    @Override
    @Nonnull
    public final HCOption addOptionAt(@Nonnegative int n, @Nonnull HCOption hCOption) {
        ValueEnforcer.notNull((Object)hCOption, (String)"Option");
        if (!hCOption.isSelectionDefined()) {
            hCOption.setSelected(this.isPreselectedValue(hCOption.getValue()));
        }
        this.onAddOption(hCOption);
        this.m_aOptions.add(n, (Object)hCOption);
        return hCOption;
    }

    @Override
    @Nonnull
    public final IMPLTYPE addOptionGroup(@Nullable HCOptGroup hCOptGroup) {
        if (hCOptGroup != null) {
            this.m_aOptions.add((Object)hCOptGroup);
        }
        return (IMPLTYPE)((AbstractHCSelect)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE removeAllOptions() {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (IHCNode iHCNode : this.m_aOptions) {
            if (iHCNode instanceof HCOption) continue;
            commonsArrayList.add((Object)iHCNode);
        }
        this.m_aOptions = commonsArrayList;
        return (IMPLTYPE)((AbstractHCSelect)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE removeAllOptionGroups() {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (IHCNode iHCNode : this.m_aOptions) {
            if (iHCNode instanceof HCOptGroup) continue;
            commonsArrayList.add((Object)iHCNode);
        }
        this.m_aOptions = commonsArrayList;
        return (IMPLTYPE)((AbstractHCSelect)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE removeOptionAt(@Nonnegative int n) {
        int n2 = 0;
        int n3 = 0;
        for (IHCNode iHCNode : this.m_aOptions) {
            if (iHCNode instanceof HCOption && n2++ == n) {
                this.m_aOptions.remove(n3);
                break;
            }
            ++n3;
        }
        return (IMPLTYPE)((AbstractHCSelect)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE removeOptionGroupAt(@Nonnegative int n) {
        int n2 = 0;
        int n3 = 0;
        for (IHCNode iHCNode : this.m_aOptions) {
            if (iHCNode instanceof HCOptGroup && n2++ == n) {
                this.m_aOptions.remove(n3);
                break;
            }
            ++n3;
        }
        return (IMPLTYPE)((AbstractHCSelect)this.thisAsT());
    }

    @Override
    @Nonnegative
    public final int getOptionCount() {
        return this.m_aOptions.getCount(HCOption.class::isInstance);
    }

    @Override
    @Nonnegative
    public final int getOptionGroupCount() {
        return this.m_aOptions.getCount(HCOptGroup.class::isInstance);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<HCOption> getAllOptions() {
        return this.m_aOptions.getAllInstanceOf(HCOption.class);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<HCOptGroup> getAllOptionGroups() {
        return this.m_aOptions.getAllInstanceOf(HCOptGroup.class);
    }

    @Override
    @Nullable
    public final HCOption getOptionAtIndex(@Nonnegative int n) {
        return (HCOption)this.m_aOptions.getAtIndexMapped(HCOption.class::isInstance, n, HCOption.class::cast);
    }

    @Override
    @Nullable
    public final HCOptGroup getOptionGroupAtIndex(@Nonnegative int n) {
        return (HCOptGroup)this.m_aOptions.getAtIndexMapped(HCOptGroup.class::isInstance, n, HCOptGroup.class::cast);
    }

    @Override
    public final boolean hasOptions() {
        return this.m_aOptions.containsAny(HCOption.class::isInstance);
    }

    @Override
    public final boolean hasOptionGroups() {
        return this.m_aOptions.containsAny(HCOptGroup.class::isInstance);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<HCOption> getAllSelectedOptions() {
        return this.m_aOptions.getAllMapped(PRED_SELECTED_OPTION, HCOption.class::cast);
    }

    @Override
    @Nullable
    public HCOption getFirstSelectedOption() {
        return (HCOption)this.m_aOptions.findFirstMapped(PRED_SELECTED_OPTION, HCOption.class::cast);
    }

    @Override
    @Nonnegative
    public final int getSelectedOptionCount() {
        return this.m_aOptions.getCount(PRED_SELECTED_OPTION);
    }

    @Override
    public final boolean hasSelectedOption() {
        return this.m_aOptions.containsAny(PRED_SELECTED_OPTION);
    }

    @Nullable
    @ReturnsMutableObject
    public final ICommonsList<IHCNode> children() {
        return this.m_aOptions;
    }

    @Nullable
    @ReturnsMutableCopy
    public final ICommonsList<IHCNode> getAllChildren() {
        return (ICommonsList)this.m_aOptions.getClone();
    }

    @Nonnull
    @ReturnsImmutableObject
    public final ICommonsIterable<IHCNode> getChildren() {
        return this.m_aOptions;
    }

    @Override
    @Nullable
    public final IHCNode getChildAtIndex(int n) {
        return (IHCNode)this.m_aOptions.getAtIndex(n);
    }

    @Override
    @Nullable
    public final IHCNode getFirstChild() {
        return (IHCNode)this.m_aOptions.getFirstOrNull();
    }

    @Override
    @Nullable
    public final IHCNode getLastChild() {
        return (IHCNode)this.m_aOptions.getLastOrNull();
    }

    @Override
    public final boolean hasChildren() {
        return this.m_aOptions.isNotEmpty();
    }

    @Override
    public final int getChildCount() {
        return this.m_aOptions.size();
    }

    @Override
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (StringHelper.hasText((String)this.m_sForm)) {
            iMicroElement.setAttribute(CHTMLAttributes.FORM, this.m_sForm);
        }
        if (this.m_bMultiple) {
            iMicroElement.setAttribute(CHTMLAttributes.MULTIPLE, CHTMLAttributeValues.MULTIPLE);
        }
        if (this.m_nSize > 1) {
            iMicroElement.setAttribute(CHTMLAttributes.SIZE, this.m_nSize);
        }
        if (this.m_aOptions.isNotEmpty()) {
            for (IHCNode iHCNode : this.m_aOptions) {
                iMicroElement.appendChild(iHCNode.convertToMicroNode(iHCConversionSettingsToNode));
            }
        } else if (!this.getElement().mayBeSelfClosed()) {
            iMicroElement.appendText((CharSequence)"");
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIfNotNull("form", (Object)this.m_sForm).append("multiple", this.m_bMultiple).append("size", this.m_nSize).append("options", this.m_aOptions).appendIf("preselectedValues", this.m_aPreselectedValues, CollectionHelper::isNotEmpty).getToString();
    }
}

