/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.script;

import com.helger.html.hc.HCHelper;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.script.HCScriptFile;
import com.helger.html.hc.html.script.IHCScript;
import com.helger.html.hc.html.script.IHCScriptInline;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class HCJSNodeDetector {
    private static final HCJSNodeDetector INSTANCE = new HCJSNodeDetector();

    private HCJSNodeDetector() {
    }

    public static boolean isJSNode(@Nullable IHCNode iHCNode) {
        IHCNode iHCNode2 = HCHelper.getUnwrappedNode(iHCNode);
        return HCJSNodeDetector.isDirectJSNode(iHCNode2);
    }

    public static boolean isDirectJSNode(@Nullable IHCNode iHCNode) {
        return iHCNode instanceof IHCScript;
    }

    public static boolean isJSInlineNode(@Nullable IHCNode iHCNode) {
        IHCNode iHCNode2 = HCHelper.getUnwrappedNode(iHCNode);
        return HCJSNodeDetector.isDirectJSInlineNode(iHCNode2);
    }

    public static boolean isDirectJSInlineNode(@Nullable IHCNode iHCNode) {
        if (iHCNode instanceof IHCScriptInline) {
            IHCScriptInline iHCScriptInline = (IHCScriptInline)iHCNode;
            return !"module".equals(iHCScriptInline.getType());
        }
        return false;
    }

    public static boolean isJSFileNode(@Nullable IHCNode iHCNode) {
        IHCNode iHCNode2 = HCHelper.getUnwrappedNode(iHCNode);
        return HCJSNodeDetector.isDirectJSFileNode(iHCNode2);
    }

    public static boolean isDirectJSFileNode(@Nullable IHCNode iHCNode) {
        return iHCNode instanceof HCScriptFile;
    }
}

