/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.impl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsIterable;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.EContinue;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.impl.AbstractHCNode;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.xml.microdom.IMicroContainer;
import com.helger.xml.microdom.MicroContainer;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractHCHasChildrenMutable<IMPLTYPE extends AbstractHCHasChildrenMutable<IMPLTYPE, CHILDTYPE>, CHILDTYPE extends IHCNode>
extends AbstractHCNode
implements IHCHasChildrenMutable<IMPLTYPE, CHILDTYPE> {
    private ICommonsList<CHILDTYPE> m_aChildren;

    @Override
    public final boolean hasChildren() {
        return CollectionHelper.isNotEmpty(this.m_aChildren);
    }

    @OverrideOnDemand
    protected void beforeAddChild(@Nonnull CHILDTYPE CHILDTYPE) {
    }

    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected void afterAddChild(@Nonnegative int n, @Nonnull CHILDTYPE CHILDTYPE) {
    }

    private void _internalAddChild(@CheckForSigned int n, @Nullable CHILDTYPE CHILDTYPE) {
        if (CHILDTYPE == this) {
            throw new IllegalArgumentException("Cannot append child to self: " + CHILDTYPE);
        }
        if (CHILDTYPE != null) {
            int n2;
            this.beforeAddChild(CHILDTYPE);
            if (this.m_aChildren == null) {
                this.m_aChildren = new CommonsArrayList();
            }
            if (n < 0) {
                n2 = this.m_aChildren.size();
                this.m_aChildren.add(CHILDTYPE);
            } else {
                n2 = n;
                this.m_aChildren.add(n, CHILDTYPE);
            }
            this.afterAddChild(n2, CHILDTYPE);
        }
    }

    @Override
    @Nonnull
    public final IMPLTYPE addChild(@Nullable CHILDTYPE CHILDTYPE) {
        this._internalAddChild(-1, CHILDTYPE);
        return (IMPLTYPE)((AbstractHCHasChildrenMutable)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE addChildAt(@Nonnegative int n, @Nullable CHILDTYPE CHILDTYPE) {
        ValueEnforcer.isBetweenInclusive((int)n, (String)"Index", (int)0, (int)this.getChildCount());
        this._internalAddChild(n, CHILDTYPE);
        return (IMPLTYPE)((AbstractHCHasChildrenMutable)this.thisAsT());
    }

    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected void afterRemoveChild(@Nonnegative int n, @Nonnull CHILDTYPE CHILDTYPE) {
    }

    @Override
    @Nonnull
    public final IMPLTYPE removeChild(@Nullable CHILDTYPE CHILDTYPE) {
        int n;
        if (CHILDTYPE != null && this.m_aChildren != null && (n = this.m_aChildren.indexOf(CHILDTYPE)) >= 0) {
            this.removeChildAt(n);
        }
        return (IMPLTYPE)((AbstractHCHasChildrenMutable)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE removeChildAt(@Nonnegative int n) {
        IHCNode iHCNode = (IHCNode)CollectionHelper.removeAndReturnElementAtIndex(this.m_aChildren, (int)n);
        if (iHCNode != null) {
            this.afterRemoveChild(n, iHCNode);
        }
        return (IMPLTYPE)((AbstractHCHasChildrenMutable)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE removeAllChildren() {
        if (this.m_aChildren != null) {
            while (this.m_aChildren.isNotEmpty()) {
                this.removeChildAt(0);
            }
            this.m_aChildren = null;
        }
        return (IMPLTYPE)((AbstractHCHasChildrenMutable)this.thisAsT());
    }

    @Override
    @Nonnegative
    public final int getChildCount() {
        return CollectionHelper.getSize(this.m_aChildren);
    }

    @Nullable
    @ReturnsMutableObject(value="speed")
    protected final ICommonsList<CHILDTYPE> directGetAllChildren() {
        return this.m_aChildren;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<CHILDTYPE> getAllChildren() {
        return new CommonsArrayList(this.m_aChildren);
    }

    @Nullable
    public final ICommonsIterable<CHILDTYPE> getChildren() {
        return this.m_aChildren;
    }

    @Override
    public final void forAllChildren(@Nonnull Consumer<? super IHCNode> consumer) {
        if (this.m_aChildren != null) {
            this.m_aChildren.forEach(consumer);
        }
    }

    @Override
    @Nonnull
    public final EContinue forAllChildrenBreakable(@Nonnull Function<? super IHCNode, EContinue> function) {
        if (this.m_aChildren != null) {
            return this.m_aChildren.forEachBreakable(function);
        }
        return EContinue.CONTINUE;
    }

    @Override
    public final void forAllChildren(@Nonnull Predicate<? super IHCNode> predicate, @Nonnull Consumer<? super IHCNode> consumer) {
        if (this.m_aChildren != null) {
            this.m_aChildren.findAll(predicate, consumer);
        }
    }

    @Override
    public <DSTTYPE> void forAllChildrenMapped(@Nonnull Predicate<? super IHCNode> predicate, @Nonnull Function<? super IHCNode, ? extends DSTTYPE> function, @Nonnull Consumer<? super DSTTYPE> consumer) {
        if (this.m_aChildren != null) {
            this.m_aChildren.findAllMapped(predicate, function, consumer);
        }
    }

    @Nullable
    public final CHILDTYPE getChildAtIndex(@Nonnegative int n) {
        return (CHILDTYPE)((IHCNode)CollectionHelper.getAtIndex(this.m_aChildren, (int)n, null));
    }

    @Nullable
    public final CHILDTYPE getFirstChild() {
        return (CHILDTYPE)((IHCNode)CollectionHelper.getFirstElement(this.m_aChildren));
    }

    @Nullable
    public final CHILDTYPE findFirstChild(@Nonnull Predicate<? super IHCNode> predicate) {
        return (CHILDTYPE)(this.m_aChildren == null ? null : (IHCNode)this.m_aChildren.findFirst(predicate));
    }

    @Override
    @Nullable
    public final <DSTTYPE> DSTTYPE findFirstChildMapped(@Nonnull Predicate<? super IHCNode> predicate, @Nonnull Function<? super IHCNode, ? extends DSTTYPE> function) {
        return (DSTTYPE)(this.m_aChildren == null ? null : this.m_aChildren.findFirstMapped(predicate, function));
    }

    @Nullable
    public final CHILDTYPE getLastChild() {
        return (CHILDTYPE)((IHCNode)CollectionHelper.getLastElement(this.m_aChildren));
    }

    @Override
    @Nonnull
    public final IMPLTYPE sortAllChildren(@Nonnull Comparator<? super CHILDTYPE> comparator) {
        ValueEnforcer.notNull(comparator, (String)"Comparator");
        if (this.m_aChildren != null) {
            this.m_aChildren.sort(comparator);
        }
        return (IMPLTYPE)((AbstractHCHasChildrenMutable)this.thisAsT());
    }

    @Nonnull
    public final HCNodeList getAllChildrenAsNodeList() {
        return (HCNodeList)new HCNodeList().addChildren((Iterable)this.m_aChildren);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    public boolean canConvertToMicroNode(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        if (this.hasChildren()) {
            for (IHCNode iHCNode : this.m_aChildren) {
                if (!iHCNode.canConvertToMicroNode(iHCConversionSettingsToNode)) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    @Nonempty
    @OverrideOnDemand
    protected ICommonsList<? extends CHILDTYPE> getChildrenFormEmitting(@Nonnull @Nonempty ICommonsList<CHILDTYPE> iCommonsList) {
        return iCommonsList;
    }

    @Nonnull
    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected IMicroContainer internalConvertToMicroNode(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        MicroContainer microContainer = new MicroContainer();
        if (this.hasChildren()) {
            for (IHCNode iHCNode : this.getChildrenFormEmitting(this.m_aChildren)) {
                microContainer.appendChild(iHCNode.convertToMicroNode(iHCConversionSettingsToNode));
            }
        }
        return microContainer;
    }

    @Override
    @Nonnull
    public String getPlainText() {
        if (!this.hasChildren()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (IHCNode iHCNode : this.getChildrenFormEmitting(this.m_aChildren)) {
            String string = iHCNode.getPlainText();
            if (!StringHelper.hasText((String)string)) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("children", this.m_aChildren).getToString();
    }
}

