/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.special;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.media.CSSMediaList;
import com.helger.css.media.ICSSMediaList;
import com.helger.html.resource.css.ConstantCSSCodeProvider;
import com.helger.html.resource.css.ICSSCodeProvider;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InlineCSSList {
    private final ICommonsList<Item> m_aItems = new CommonsArrayList();

    @Nonnull
    public static ICSSMediaList getSafeCSSMediaList(@Nullable ICSSMediaList iCSSMediaList) {
        if (iCSSMediaList != null && !iCSSMediaList.hasNoMediaOrAll()) {
            return iCSSMediaList;
        }
        return new CSSMediaList();
    }

    public void addInlineCSS(@Nullable ICSSMediaList iCSSMediaList, @Nonnull CharSequence charSequence) {
        Item item;
        Key key;
        Key key2 = new Key(iCSSMediaList);
        Item item2 = (Item)this.m_aItems.getLastOrNull();
        Key key3 = key = item2 == null ? null : item2.getKey();
        if (key != null && key.equals(key2)) {
            item = item2;
        } else {
            item = new Item(key2);
            this.m_aItems.add((Object)item);
        }
        item.appendCSS(charSequence);
    }

    void clear() {
        this.m_aItems.clear();
    }

    public boolean isEmpty() {
        return this.m_aItems.isEmpty();
    }

    public boolean isNotEmpty() {
        return this.m_aItems.isNotEmpty();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ICSSCodeProvider> getAll() {
        return this.m_aItems.getAllMapped(item -> new ConstantCSSCodeProvider(item.getCSS(), null, item.getMediaList(), true));
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Items", this.m_aItems).getToString();
    }

    private static final class Key
    implements Serializable {
        private final ICSSMediaList m_aMediaList;

        public Key(@Nullable ICSSMediaList iCSSMediaList) {
            this.m_aMediaList = InlineCSSList.getSafeCSSMediaList(iCSSMediaList);
        }

        @Nonnull
        public ICSSMediaList getMediaList() {
            return this.m_aMediaList;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || !this.getClass().equals(object.getClass())) {
                return false;
            }
            Key key = (Key)object;
            return this.m_aMediaList.equals(key.m_aMediaList);
        }

        public int hashCode() {
            return new HashCodeGenerator((Object)this).append((Object)this.m_aMediaList).getHashCode();
        }

        public String toString() {
            return new ToStringGenerator(null).append("MediaList", (Object)this.m_aMediaList).getToString();
        }
    }

    private static final class Item
    implements Serializable {
        private final Key m_aKey;
        private final StringBuilder m_aCSS = new StringBuilder();

        public Item(@Nonnull Key key) {
            this.m_aKey = (Key)ValueEnforcer.notNull((Object)key, (String)"Key");
        }

        void appendCSS(@Nonnull CharSequence charSequence) {
            this.m_aCSS.append(charSequence);
        }

        @Nonnull
        Key getKey() {
            return this.m_aKey;
        }

        @Nonnull
        public ICSSMediaList getMediaList() {
            return this.m_aKey.getMediaList();
        }

        @Nonnull
        public String getCSS() {
            return this.m_aCSS.toString();
        }

        public String toString() {
            return new ToStringGenerator((Object)this).append("Key", (Object)this.m_aKey).append("CSS", (Object)this.m_aCSS).getToString();
        }
    }
}

