/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.js;

import com.helger.commons.string.StringHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class JSFilenameHelper {
    private static final String JS_IN_URL = ".js?";
    private static final String JS_IN_URL2 = ".js#";
    private static final String CJS_IN_URL = ".cjs?";
    private static final String CJS_IN_URL2 = ".cjs#";
    private static final String MJS_IN_URL = ".mjs?";
    private static final String MJS_IN_URL2 = ".mjs#";
    private static final String MIN_JS_IN_URL = ".min.js?";
    private static final String MIN_JS_IN_URL2 = ".min.js#";
    private static final String MIN_CJS_IN_URL = ".min.cjs?";
    private static final String MIN_CJS_IN_URL2 = ".min.cjs#";
    private static final String MIN_MJS_IN_URL = ".min.mjs?";
    private static final String MIN_MJS_IN_URL2 = ".min.mjs#";

    private JSFilenameHelper() {
    }

    public static boolean isJSFilename(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return false;
        }
        return string.endsWith(".js") || string.endsWith(".cjs") || string.endsWith(".mjs") || string.contains(JS_IN_URL) || string.contains(CJS_IN_URL) || string.contains(MJS_IN_URL) || string.contains(JS_IN_URL2) || string.contains(CJS_IN_URL2) || string.contains(MJS_IN_URL2) || string.startsWith("https://www.googletagmanager.com/gtag/js");
    }

    public static boolean isMinifiedJSFilename(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return false;
        }
        return string.endsWith(".min.js") || string.endsWith(".min.cjs") || string.endsWith(".min.mjs") || string.contains(MIN_JS_IN_URL) || string.contains(MIN_CJS_IN_URL) || string.contains(MIN_MJS_IN_URL) || string.contains(MIN_JS_IN_URL2) || string.contains(MIN_CJS_IN_URL2) || string.contains(MIN_MJS_IN_URL2);
    }

    public static boolean isRegularJSFilename(@Nullable String string) {
        return JSFilenameHelper.isJSFilename(string) && !JSFilenameHelper.isMinifiedJSFilename(string);
    }

    @Nonnull
    public static String getMinifiedJSFilename(@Nonnull String string) {
        if (!JSFilenameHelper.isJSFilename(string)) {
            throw new IllegalArgumentException("Passed filename '" + string + "' is not a JS filename!");
        }
        if (JSFilenameHelper.isMinifiedJSFilename(string)) {
            return string;
        }
        return string.replace(".js", ".min.js").replace(".cjs", ".min.cjs").replace(".mjs", ".min.mjs");
    }
}

