/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.markdown;

import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.IURLProtocol;
import com.helger.commons.url.URLProtocolRegistry;
import com.helger.html.EHTMLElement;
import javax.annotation.Nullable;

final class MarkdownHTML {
    private static final EHTMLElement[] BLOCK_ELEMENTS = new EHTMLElement[]{EHTMLElement.ADDRESS, EHTMLElement.BLOCKQUOTE, EHTMLElement.DEL, EHTMLElement.DIV, EHTMLElement.DL, EHTMLElement.FIELDSET, EHTMLElement.FORM, EHTMLElement.H1, EHTMLElement.H2, EHTMLElement.H3, EHTMLElement.H4, EHTMLElement.H5, EHTMLElement.H6, EHTMLElement.HR, EHTMLElement.INS, EHTMLElement.NOSCRIPT, EHTMLElement.OL, EHTMLElement.P, EHTMLElement.PRE, EHTMLElement.TABLE, EHTMLElement.UL};
    private static final EHTMLElement[] UNSAFE_ELEMENTS = new EHTMLElement[]{EHTMLElement.APPLET, EHTMLElement.HEAD, EHTMLElement.HTML, EHTMLElement.BODY, EHTMLElement.FRAME, EHTMLElement.FRAMESET, EHTMLElement.IFRAME, EHTMLElement.SCRIPT, EHTMLElement.OBJECT};
    private static final ICommonsSet<String> LINK_PREFIX = new CommonsHashSet();
    private static final ICommonsSet<String> HTML_BLOCK_ELEMENTS = new CommonsHashSet();
    private static final ICommonsSet<String> HTML_UNSAFE = new CommonsHashSet();

    private MarkdownHTML() {
    }

    public static boolean isLinkPrefix(String string) {
        return LINK_PREFIX.contains((Object)string);
    }

    public static boolean isHtmlBlockElement(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return false;
        }
        return HTML_BLOCK_ELEMENTS.contains((Object)EHTMLElement.getUnifiedHTMLElementName(string));
    }

    public static boolean isUnsafeHtmlElement(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return false;
        }
        return HTML_UNSAFE.contains((Object)EHTMLElement.getUnifiedHTMLElementName(string));
    }

    static {
        for (IURLProtocol iURLProtocol : URLProtocolRegistry.getInstance().getAllProtocols()) {
            String string = iURLProtocol.getProtocol();
            int n = string.indexOf(58);
            LINK_PREFIX.add((Object)(n < 0 ? string : string.substring(0, n)));
        }
        for (EHTMLElement eHTMLElement : BLOCK_ELEMENTS) {
            HTML_BLOCK_ELEMENTS.add((Object)eHTMLElement.getElementName());
        }
        for (EHTMLElement eHTMLElement : UNSAFE_ELEMENTS) {
            HTML_UNSAFE.add((Object)eHTMLElement.getElementName());
        }
    }
}

