/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.io;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.callback.IThrowingRunnable;
import com.helger.commons.concurrent.BasicThreadFactory;
import com.helger.commons.concurrent.ExecutorServiceHelper;
import com.helger.commons.functional.IThrowingSupplier;
import com.helger.commons.timing.StopWatch;
import com.helger.scope.IScope;
import com.helger.scope.singleton.AbstractGlobalSingleton;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhotonWorkerPool
extends AbstractGlobalSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhotonWorkerPool.class);
    private final ExecutorService m_aES;

    @Deprecated(forRemoval=false)
    @UsedViaReflection
    public PhotonWorkerPool() {
        this(Runtime.getRuntime().availableProcessors() * 2);
    }

    public PhotonWorkerPool(@Nonnegative int n) {
        this(Executors.newFixedThreadPool(n, (ThreadFactory)new BasicThreadFactory.Builder().daemon(true).namingPattern("ph-oton-worker-%d").build()));
    }

    public PhotonWorkerPool(@Nonnull ExecutorService executorService) {
        ValueEnforcer.notNull((Object)executorService, (String)"ExecutorService");
        this.m_aES = executorService;
    }

    @Nonnull
    public static PhotonWorkerPool getInstance() {
        return (PhotonWorkerPool)PhotonWorkerPool.getGlobalSingleton(PhotonWorkerPool.class);
    }

    protected void onDestroy(@Nonnull IScope iScope) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ph-oton worker pool about to be closed");
        }
        ExecutorServiceHelper.shutdownAndWaitUntilAllTasksAreFinished((ExecutorService)this.m_aES);
        LOGGER.info("ph-oton worker pool was closed!");
    }

    @Nonnull
    public CompletableFuture<Void> run(@Nonnull String string, @Nonnull Runnable runnable) {
        return CompletableFuture.runAsync(() -> {
            StopWatch stopWatch = StopWatch.createdStarted();
            LOGGER.info("Starting '" + string + "'");
            try {
                runnable.run();
            }
            catch (RuntimeException runtimeException) {
                LOGGER.error("Error running ph-oton runner " + runnable, (Throwable)runtimeException);
            }
            finally {
                stopWatch.stop();
                LOGGER.info("Finished '" + string + "' after " + stopWatch.getMillis() + " milliseconds");
            }
        }, this.m_aES);
    }

    @Nonnull
    public CompletableFuture<Void> runThrowing(@Nonnull String string, @Nonnull IThrowingRunnable<? extends Exception> iThrowingRunnable) {
        return CompletableFuture.runAsync(() -> {
            StopWatch stopWatch = StopWatch.createdStarted();
            LOGGER.info("Starting '" + string + "'");
            try {
                iThrowingRunnable.run();
            }
            catch (Exception exception) {
                LOGGER.error("Error running ph-oton runner " + iThrowingRunnable, (Throwable)exception);
            }
            finally {
                stopWatch.stop();
                LOGGER.info("Finished '" + string + "' after " + stopWatch.getMillis() + " milliseconds");
            }
        }, this.m_aES);
    }

    @Nonnull
    public <T> CompletableFuture<T> supply(@Nonnull String string, @Nonnull Supplier<T> supplier) {
        return CompletableFuture.supplyAsync(() -> {
            StopWatch stopWatch = StopWatch.createdStarted();
            LOGGER.info("Starting '" + string + "'");
            try {
                Object t = supplier.get();
                return t;
            }
            catch (RuntimeException runtimeException) {
                LOGGER.error("Error running ph-oton supplier " + supplier, (Throwable)runtimeException);
                Object var4_5 = null;
                return var4_5;
            }
            finally {
                stopWatch.stop();
                LOGGER.info("Finished '" + string + "' after " + stopWatch.getMillis() + " milliseconds");
            }
        }, this.m_aES);
    }

    @Nonnull
    public <T> CompletableFuture<T> supplyThrowing(@Nonnull String string, @Nonnull IThrowingSupplier<T, ? extends Exception> iThrowingSupplier) {
        return CompletableFuture.supplyAsync(() -> {
            StopWatch stopWatch = StopWatch.createdStarted();
            LOGGER.info("Starting '" + string + "'");
            try {
                Object object = iThrowingSupplier.get();
                return object;
            }
            catch (Exception exception) {
                LOGGER.error("Error running ph-oton supplier " + iThrowingSupplier, (Throwable)exception);
                Object var4_5 = null;
                return var4_5;
            }
            finally {
                stopWatch.stop();
                LOGGER.info("Finished '" + string + "' after " + stopWatch.getMillis() + " milliseconds");
            }
        }, this.m_aES);
    }
}

