/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.jetty;

import com.helger.commons.ValueEnforcer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JettyStopper {
    private static final Logger LOGGER = LoggerFactory.getLogger(JettyStopper.class);
    private String m_sStopKey = "secret";
    private int m_nStopPort = 8079;

    @Nonnull
    public JettyStopper setStopKey(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"StopKey");
        this.m_sStopKey = string;
        return this;
    }

    @Nonnull
    public JettyStopper setStopPort(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"StopPort");
        this.m_nStopPort = n;
        return this;
    }

    public void run() throws IOException {
        try (Socket socket = new Socket(InetAddress.getByName(null), this.m_nStopPort);){
            socket.setSoLinger(false, 0);
            try (OutputStream outputStream = socket.getOutputStream();){
                LOGGER.info("Sending Jetty stop request to port " + this.m_nStopPort);
                outputStream.write((this.m_sStopKey + "\r\nstop\r\n").getBytes(StandardCharsets.UTF_8));
                outputStream.flush();
            }
            LOGGER.info("Done");
        }
        catch (ConnectException connectException) {
            LOGGER.warn("Jetty is not running");
        }
    }
}

