/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.lock;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ELockType;
import com.helger.commons.annotation.MustBeLocked;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.security.lock.ELocked;
import com.helger.photon.security.lock.ILockInfo;
import com.helger.photon.security.lock.ILockManager;
import com.helger.photon.security.lock.LockInfo;
import com.helger.photon.security.lock.LockResult;
import com.helger.security.authentication.subject.user.ICurrentUserIDProvider;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DefaultLockManager<IDTYPE>
implements ILockManager<IDTYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLockManager.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private ICurrentUserIDProvider m_aCurrentUserIDProvider;
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<IDTYPE, ILockInfo> m_aLockedObjs = new CommonsHashMap();
    private final AtomicBoolean m_aSilentMode = new AtomicBoolean(true);

    public DefaultLockManager(@Nonnull ICurrentUserIDProvider iCurrentUserIDProvider) {
        this.setCurrentUserIDProvider(iCurrentUserIDProvider);
    }

    public boolean isSilentMode() {
        return this.m_aSilentMode.get();
    }

    public boolean setSilentMode(boolean bl) {
        return this.m_aSilentMode.getAndSet(bl);
    }

    public final void setCurrentUserIDProvider(@Nonnull ICurrentUserIDProvider iCurrentUserIDProvider) {
        ValueEnforcer.notNull((Object)iCurrentUserIDProvider, (String)"CurrentUserIDProvider");
        this.m_aRWLock.writeLocked(() -> {
            this.m_aCurrentUserIDProvider = iCurrentUserIDProvider;
        });
    }

    @Nullable
    private String _getCurrentUserID() {
        return (String)this.m_aRWLock.readLockedGet(() -> this.m_aCurrentUserIDProvider.getCurrentUserID());
    }

    @Override
    @Nullable
    public final ILockInfo getLockInfo(@Nullable IDTYPE IDTYPE) {
        return (ILockInfo)this.m_aRWLock.readLockedGet(() -> (ILockInfo)this.m_aLockedObjs.get(IDTYPE));
    }

    @Override
    @Nullable
    public final String getLockUserID(@Nullable IDTYPE IDTYPE) {
        ILockInfo iLockInfo = this.getLockInfo(IDTYPE);
        return iLockInfo != null ? iLockInfo.getLockUserID() : null;
    }

    @Override
    @Nullable
    public final LocalDateTime getLockDateTime(@Nullable IDTYPE IDTYPE) {
        ILockInfo iLockInfo = this.getLockInfo(IDTYPE);
        return iLockInfo != null ? iLockInfo.getLockDateTime() : null;
    }

    @Override
    @Nonnull
    public final ELocked lockObject(@Nonnull IDTYPE IDTYPE) {
        ValueEnforcer.notNull(IDTYPE, (String)"ObjectID");
        String string = this._getCurrentUserID();
        return this.lockObject(IDTYPE, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private LockResult<IDTYPE> _lockObjectAndUnlockOthers(@Nonnull IDTYPE IDTYPE, @Nullable String string, boolean bl) {
        ELocked eLocked;
        if (StringHelper.hasNoText((String)string)) {
            return LockResult.createFailure(IDTYPE);
        }
        boolean bl2 = false;
        CommonsArrayList commonsArrayList = null;
        this.m_aRWLock.writeLock().lock();
        try {
            ILockInfo iLockInfo;
            if (bl) {
                commonsArrayList = new CommonsArrayList();
                this._unlockAllObjects(string, (Set<IDTYPE>)new CommonsHashSet(IDTYPE), (List<IDTYPE>)commonsArrayList);
            }
            if ((iLockInfo = (ILockInfo)this.m_aLockedObjs.get(IDTYPE)) != null) {
                eLocked = ELocked.valueOf(iLockInfo.getLockUserID().equals(string));
            } else {
                this.m_aLockedObjs.put(IDTYPE, (Object)new LockInfo(string));
                eLocked = ELocked.LOCKED;
                bl2 = true;
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        if (!this.isSilentMode() && LOGGER.isInfoEnabled()) {
            if (CollectionHelper.isNotEmpty((Collection)commonsArrayList)) {
                LOGGER.info("Before locking, unlocked all objects of user '" + string + "': " + commonsArrayList + " except '" + IDTYPE + "'");
            }
            if (bl2) {
                LOGGER.info("User '" + string + "' locked object '" + IDTYPE + "'");
            }
        }
        return new LockResult<IDTYPE>(IDTYPE, eLocked, bl2, commonsArrayList);
    }

    @Override
    @Nonnull
    public final ELocked lockObject(@Nonnull IDTYPE IDTYPE, @Nullable String string) {
        ValueEnforcer.notNull(IDTYPE, (String)"ObjectID");
        LockResult<IDTYPE> lockResult = this._lockObjectAndUnlockOthers(IDTYPE, string, false);
        return ELocked.valueOf(lockResult);
    }

    @Override
    @Nonnull
    public final LockResult<IDTYPE> lockObjectAndUnlockAllOthers(@Nonnull IDTYPE IDTYPE) {
        ValueEnforcer.notNull(IDTYPE, (String)"ObjectID");
        String string = this._getCurrentUserID();
        return this.lockObjectAndUnlockAllOthers(IDTYPE, string);
    }

    @Override
    @Nonnull
    public final LockResult<IDTYPE> lockObjectAndUnlockAllOthers(@Nonnull IDTYPE IDTYPE, @Nullable String string) {
        ValueEnforcer.notNull(IDTYPE, (String)"ObjectID");
        return this._lockObjectAndUnlockOthers(IDTYPE, string, true);
    }

    @Override
    @Nonnull
    public final EChange unlockObject(@Nonnull IDTYPE IDTYPE) {
        String string = this._getCurrentUserID();
        if (StringHelper.hasNoText((String)string)) {
            return EChange.UNCHANGED;
        }
        return this.unlockObject(string, IDTYPE);
    }

    @Override
    @Nonnull
    public final EChange unlockObject(@Nonnull String string, @Nonnull IDTYPE IDTYPE) {
        ValueEnforcer.notNull((Object)string, (String)"UserID");
        ValueEnforcer.notNull(IDTYPE, (String)"ObjectID");
        ILockInfo iLockInfo = this.getLockInfo(IDTYPE);
        if (iLockInfo == null) {
            if (!this.isSilentMode() && LOGGER.isWarnEnabled()) {
                LOGGER.warn("User '" + string + "' could not unlock object '" + IDTYPE + "' because it is not locked");
            }
            return EChange.UNCHANGED;
        }
        if (!iLockInfo.getLockUserID().equals(string)) {
            if (!this.isSilentMode() && LOGGER.isWarnEnabled()) {
                LOGGER.warn("User '" + string + "' could not unlock object '" + IDTYPE + "' because it is locked by '" + iLockInfo.getLockUserID() + "'");
            }
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_aLockedObjs.remove(IDTYPE) == null) {
                throw new IllegalStateException("Internal inconsistency: removing '" + IDTYPE + "' from lock list failed!");
            }
        });
        if (!this.isSilentMode() && LOGGER.isInfoEnabled()) {
            LOGGER.info("User '" + string + "' unlocked object '" + IDTYPE + "'");
        }
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<IDTYPE> unlockAllObjectsOfCurrentUser() {
        return this.unlockAllObjectsOfCurrentUserExcept(null);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<IDTYPE> unlockAllObjectsOfCurrentUserExcept(@Nullable Set<IDTYPE> set) {
        String string = this._getCurrentUserID();
        return this.unlockAllObjectsOfUserExcept(string, set);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<IDTYPE> unlockAllObjectsOfUser(@Nullable String string) {
        return this.unlockAllObjectsOfUserExcept(string, null);
    }

    @MustBeLocked(value=ELockType.WRITE)
    private void _unlockAllObjects(@Nonnull @Nonempty String string, @Nullable Set<IDTYPE> set, @Nonnull List<IDTYPE> list) {
        for (Object object : this.m_aLockedObjs.entrySet()) {
            String string2 = ((ILockInfo)object.getValue()).getLockUserID();
            if (!string2.equals(string)) continue;
            Object k = object.getKey();
            if (set != null && set.contains(k)) continue;
            list.add(k);
        }
        for (Object object : list) {
            if (this.m_aLockedObjs.remove(object) != null) continue;
            throw new IllegalStateException("Internal inconsistency: user '" + string + "' failed to unlock '" + object + "' from " + list);
        }
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<IDTYPE> unlockAllObjectsOfUserExcept(@Nullable String string, @Nullable Set<IDTYPE> set) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (StringHelper.hasText((String)string)) {
            this.m_aRWLock.writeLocked(() -> this.lambda$unlockAllObjectsOfUserExcept$4(string, set, (ICommonsList)commonsArrayList));
            if (commonsArrayList.isNotEmpty() && !this.isSilentMode() && LOGGER.isInfoEnabled()) {
                LOGGER.info("Unlocked all objects of user '" + string + "': " + commonsArrayList + (CollectionHelper.isEmpty(set) ? "" : " except " + set));
            }
        }
        return commonsArrayList;
    }

    @Override
    public final boolean isObjectLockedByCurrentUser(@Nullable IDTYPE IDTYPE) {
        String string = this.getLockUserID(IDTYPE);
        if (string == null) {
            return false;
        }
        String string2 = this._getCurrentUserID();
        return string.equals(string2);
    }

    @Override
    public final boolean isObjectLockedByOtherUser(@Nullable IDTYPE IDTYPE) {
        String string = this.getLockUserID(IDTYPE);
        if (string == null) {
            return false;
        }
        String string2 = this._getCurrentUserID();
        return !string.equals(string2);
    }

    @Override
    public final boolean isObjectLockedByAnyUser(@Nullable IDTYPE IDTYPE) {
        return this.getLockUserID(IDTYPE) != null;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsSet<IDTYPE> getAllLockedObjects() {
        return (ICommonsSet)this.m_aRWLock.readLockedGet(() -> this.m_aLockedObjs.copyOfKeySet());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsMap<IDTYPE, ILockInfo> getAllLockInfos() {
        return (ICommonsMap)this.m_aRWLock.readLockedGet(() -> this.m_aLockedObjs.getClone());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<IDTYPE> getAllLockedObjectsOfCurrentUser() {
        String string = this._getCurrentUserID();
        return this.getAllLockedObjectsOfUser(string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<IDTYPE> getAllLockedObjectsOfUser(@Nullable String string) {
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        if (StringHelper.hasText((String)string)) {
            this.m_aRWLock.readLocked(() -> this.lambda$getAllLockedObjectsOfUser$5(string, (ICommonsSet)commonsHashSet));
        }
        return commonsHashSet;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("CurrentUserIDProvider", (Object)this.m_aCurrentUserIDProvider).append("LockedObjects", this.m_aLockedObjs).append("SilentMode", (Object)this.m_aSilentMode).getToString();
    }

    private /* synthetic */ void lambda$getAllLockedObjectsOfUser$5(String string, ICommonsSet iCommonsSet) {
        for (Map.Entry entry : this.m_aLockedObjs.entrySet()) {
            if (!((ILockInfo)entry.getValue()).getLockUserID().equals(string)) continue;
            iCommonsSet.add(entry.getKey());
        }
    }

    private /* synthetic */ void lambda$unlockAllObjectsOfUserExcept$4(String string, Set set, ICommonsList iCommonsList) {
        this._unlockAllObjects(string, set, (List<IDTYPE>)iCommonsList);
    }
}

