/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.lock;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.state.EChange;
import com.helger.photon.security.lock.ELocked;
import com.helger.photon.security.lock.ILockInfo;
import com.helger.photon.security.lock.LockResult;
import java.time.LocalDateTime;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ILockManager<IDTYPE> {
    @Nullable
    public ILockInfo getLockInfo(@Nullable IDTYPE var1);

    @Nullable
    public String getLockUserID(@Nullable IDTYPE var1);

    @Nullable
    public LocalDateTime getLockDateTime(@Nullable IDTYPE var1);

    @Nonnull
    public ELocked lockObject(@Nonnull IDTYPE var1);

    @Nonnull
    public ELocked lockObject(@Nonnull IDTYPE var1, @Nullable String var2);

    @Nonnull
    public LockResult<IDTYPE> lockObjectAndUnlockAllOthers(@Nonnull IDTYPE var1);

    @Nonnull
    public LockResult<IDTYPE> lockObjectAndUnlockAllOthers(@Nonnull IDTYPE var1, @Nullable String var2);

    @Nonnull
    public EChange unlockObject(@Nonnull IDTYPE var1);

    @Nonnull
    public EChange unlockObject(@Nonnull String var1, @Nonnull IDTYPE var2);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IDTYPE> unlockAllObjectsOfCurrentUser();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IDTYPE> unlockAllObjectsOfCurrentUserExcept(@Nullable Set<IDTYPE> var1);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IDTYPE> unlockAllObjectsOfUser(@Nullable String var1);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IDTYPE> unlockAllObjectsOfUserExcept(@Nullable String var1, @Nullable Set<IDTYPE> var2);

    public boolean isObjectLockedByCurrentUser(@Nullable IDTYPE var1);

    public boolean isObjectLockedByOtherUser(@Nullable IDTYPE var1);

    public boolean isObjectLockedByAnyUser(@Nullable IDTYPE var1);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<IDTYPE> getAllLockedObjects();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<IDTYPE, ILockInfo> getAllLockInfos();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<IDTYPE> getAllLockedObjectsOfCurrentUser();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<IDTYPE> getAllLockedObjectsOfUser(@Nullable String var1);
}

