/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.password;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.photon.security.password.constraint.IPasswordConstraintList;
import com.helger.photon.security.password.constraint.PasswordConstraintList;
import com.helger.photon.security.password.hash.IPasswordHashCreatorRegistrarSPI;
import com.helger.photon.security.password.hash.PasswordHashCreatorManager;
import com.helger.security.password.hash.IPasswordHashCreator;
import com.helger.security.password.hash.PasswordHash;
import com.helger.security.password.hash.PasswordHashCreatorPBKDF2_1000_48;
import com.helger.security.password.hash.PasswordHashCreatorPBKDF2_SHA256_1000_48;
import com.helger.security.password.hash.PasswordHashCreatorSHA512;
import com.helger.security.password.salt.IPasswordSalt;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class GlobalPasswordSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalPasswordSettings.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static IPasswordConstraintList s_aPasswordConstraintList = new PasswordConstraintList();
    private static final PasswordHashCreatorManager PHC_MGR = new PasswordHashCreatorManager();
    private static final GlobalPasswordSettings INSTANCE;

    private GlobalPasswordSettings() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static IPasswordConstraintList getPasswordConstraintList() {
        return (IPasswordConstraintList)RW_LOCK.readLockedGet(() -> ((IPasswordConstraintList)s_aPasswordConstraintList).getClone());
    }

    public static void setPasswordConstraintList(@Nonnull IPasswordConstraintList iPasswordConstraintList) {
        ValueEnforcer.notNull((Object)iPasswordConstraintList, (String)"PasswordConstraintList");
        IPasswordConstraintList iPasswordConstraintList2 = (IPasswordConstraintList)iPasswordConstraintList.getClone();
        RW_LOCK.writeLocked(() -> {
            s_aPasswordConstraintList = iPasswordConstraintList2;
        });
        LOGGER.info("Set global password constraints to " + iPasswordConstraintList2);
    }

    public static boolean isAnyPasswordConstraintDefined() {
        return GlobalPasswordSettings.getPasswordConstraintList().hasConstraints();
    }

    @Nonnull
    public static PasswordHashCreatorManager getPasswordHashCreatorManager() {
        return PHC_MGR;
    }

    @Nonnull
    public static PasswordHash createUserDefaultPasswordHash(@Nullable IPasswordSalt iPasswordSalt, @Nonnull String string) {
        return PHC_MGR.createUserDefaultPasswordHash(iPasswordSalt, string);
    }

    @Nonnull
    public static PasswordHash createUserPasswordHash(@Nonnull @Nonempty String string, @Nullable IPasswordSalt iPasswordSalt, @Nonnull String string2) {
        return PHC_MGR.createUserPasswordHash(string, iPasswordSalt, string2);
    }

    static {
        PHC_MGR.registerPasswordHashCreator((IPasswordHashCreator)new PasswordHashCreatorSHA512());
        PHC_MGR.registerPasswordHashCreator((IPasswordHashCreator)new PasswordHashCreatorPBKDF2_1000_48());
        PHC_MGR.registerPasswordHashCreator((IPasswordHashCreator)new PasswordHashCreatorPBKDF2_SHA256_1000_48());
        PHC_MGR.setDefaultPasswordHashCreatorAlgorithm("PBKDF2_1000_48");
        for (IPasswordHashCreatorRegistrarSPI iPasswordHashCreatorRegistrarSPI : ServiceLoaderHelper.getAllSPIImplementations(IPasswordHashCreatorRegistrarSPI.class)) {
            iPasswordHashCreatorRegistrarSPI.registerPasswordHashCreators(PHC_MGR);
        }
        INSTANCE = new GlobalPasswordSettings();
    }
}

