/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.password.constraint;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.security.password.constraint.EPasswordConstraintText;
import com.helger.photon.security.password.constraint.IPasswordConstraint;
import com.helger.xml.microdom.IMicroElement;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PasswordConstraintMaxLength
implements IPasswordConstraint {
    private static final String ATTR_MAX_LENGTH = "maxlength";
    private final int m_nMaxLength;

    public PasswordConstraintMaxLength(@Nonnegative int n) {
        this.m_nMaxLength = ValueEnforcer.isGT0((int)n, (String)"MaxLength");
    }

    @Nonnegative
    public int getMaxLength() {
        return this.m_nMaxLength;
    }

    @Override
    public boolean isPasswordValid(@Nullable String string) {
        return StringHelper.getLength((CharSequence)string) <= this.m_nMaxLength;
    }

    @Override
    @Nullable
    public String getDescription(@Nonnull Locale locale) {
        return EPasswordConstraintText.DESC_MAX_LENGTH.getDisplayTextWithArgs(locale, new Object[]{this.m_nMaxLength});
    }

    @Override
    public void fillMicroElement(@Nonnull IMicroElement iMicroElement) {
        iMicroElement.setAttribute(ATTR_MAX_LENGTH, this.m_nMaxLength);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PasswordConstraintMaxLength passwordConstraintMaxLength = (PasswordConstraintMaxLength)object;
        return this.m_nMaxLength == passwordConstraintMaxLength.m_nMaxLength;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_nMaxLength).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("maxLength", this.m_nMaxLength).getToString();
    }
}

