/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.role;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.type.ObjectType;
import com.helger.photon.security.object.StubObject;
import com.helger.photon.security.role.IRole;
import com.helger.tenancy.AbstractBusinessObject;
import com.helger.tenancy.IBusinessObject;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class Role
extends AbstractBusinessObject
implements IRole {
    public static final ObjectType OT = new ObjectType("role");
    private String m_sName;
    private String m_sDescription;

    public Role(@Nonnull @Nonempty String string, @Nullable String string2, @Nullable Map<String, String> map) {
        this(StubObject.createForCurrentUser(map), string, string2);
    }

    public Role(@Nonnull StubObject stubObject, @Nonnull @Nonempty String string, @Nullable String string2) {
        super((IBusinessObject)stubObject);
        this.setName(string);
        this.setDescription(string2);
    }

    @Nonnull
    public ObjectType getObjectType() {
        return OT;
    }

    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Nonnull
    public EChange setName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        if (string.equals(this.m_sName)) {
            return EChange.UNCHANGED;
        }
        this.m_sName = string;
        return EChange.CHANGED;
    }

    @Nullable
    public String getDescription() {
        return this.m_sDescription;
    }

    @Nonnull
    public EChange setDescription(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sDescription)) {
            return EChange.UNCHANGED;
        }
        this.m_sDescription = string;
        return EChange.CHANGED;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Name", (Object)this.m_sName).appendIfNotNull("Description", (Object)this.m_sDescription).getToString();
    }
}

