/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.role;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.id.IHasID;
import com.helger.commons.state.EChange;
import com.helger.commons.state.IChangeIndicator;
import com.helger.commons.type.ObjectType;
import com.helger.dao.DAOException;
import com.helger.photon.app.dao.AbstractPhotonMapBasedWALDAO;
import com.helger.photon.audit.AuditHelper;
import com.helger.photon.security.object.BusinessObjectHelper;
import com.helger.photon.security.object.StubObject;
import com.helger.photon.security.role.IRole;
import com.helger.photon.security.role.IRoleManager;
import com.helger.photon.security.role.IRoleModificationCallback;
import com.helger.photon.security.role.Role;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class RoleManager
extends AbstractPhotonMapBasedWALDAO<IRole, Role>
implements IRoleManager {
    private final CallbackList<IRoleModificationCallback> m_aCallbacks = new CallbackList();

    public RoleManager(@Nonnull @Nonempty String string) throws DAOException {
        super(Role.class, string);
    }

    @Nonnull
    public static Role createDefaultRoleAdministrator() {
        return new Role(StubObject.createForCurrentUserAndID("radmin"), "Administrator", (String)null);
    }

    @Nonnull
    public static Role createDefaultRoleUser() {
        return new Role(StubObject.createForCurrentUserAndID("ruser"), "User", (String)null);
    }

    @Override
    public void createDefaultsForTest() {
        if (!this.containsWithID("radmin")) {
            this.internalCreateItem((IHasID)RoleManager.createDefaultRoleAdministrator());
        }
        if (!this.containsWithID("ruser")) {
            this.internalCreateItem((IHasID)RoleManager.createDefaultRoleUser());
        }
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public CallbackList<IRoleModificationCallback> roleModificationCallbacks() {
        return this.m_aCallbacks;
    }

    @Nonnull
    private void _createNewRole(@Nonnull Role role, boolean bl) {
        this.m_aRWLock.writeLocked(() -> {
            Role cfr_ignored_0 = (Role)this.internalCreateItem((IHasID)role);
        });
        AuditHelper.onAuditCreateSuccess((ObjectType)Role.OT, (Object[])new Object[]{role.getID(), role.getName(), role.getDescription(), bl ? "predefined" : "custom"});
        this.m_aCallbacks.forEach(iRoleModificationCallback -> iRoleModificationCallback.onRoleCreated(role, bl));
    }

    @Override
    @Nonnull
    public IRole createNewRole(@Nonnull @Nonempty String string, @Nullable String string2, @Nullable Map<String, String> map) {
        Role role = new Role(string, string2, map);
        this._createNewRole(role, false);
        return role;
    }

    @Override
    @Nonnull
    public IRole createPredefinedRole(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable String string3, @Nullable Map<String, String> map) {
        Role role = new Role(StubObject.createForCurrentUserAndID(string, map), string2, string3);
        this._createNewRole(role, true);
        return role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange deleteRole(@Nullable String string) {
        this.m_aRWLock.writeLock().lock();
        try {
            Role role = (Role)this.internalDeleteItem(string);
            if (role == null) {
                AuditHelper.onAuditDeleteFailure((ObjectType)Role.OT, (Object[])new Object[]{string, "no-such-id"});
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            BusinessObjectHelper.setDeletionNow(role);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditDeleteSuccess((ObjectType)Role.OT, (Object[])new Object[]{string});
        this.m_aCallbacks.forEach(iRoleModificationCallback -> iRoleModificationCallback.onRoleDeleted(string));
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public IRole getRoleOfID(@Nullable String string) {
        return (IRole)this.getOfID(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange renameRole(@Nullable String string, @Nonnull @Nonempty String string2) {
        Role role = (Role)this.getOfID(string);
        if (role == null) {
            AuditHelper.onAuditModifyFailure((ObjectType)Role.OT, (String)"set-name", (Object[])new Object[]{string, "no-such-id"});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (role.setName(string2).isUnchanged()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            BusinessObjectHelper.setLastModificationNow(role);
            this.internalUpdateItem((IHasID)role);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess((ObjectType)Role.OT, (String)"set-name", (Object[])new Object[]{string, string2});
        this.m_aCallbacks.forEach(iRoleModificationCallback -> iRoleModificationCallback.onRoleRenamed(string));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange setRoleData(@Nullable String string, @Nonnull @Nonempty String string2, @Nullable String string3, @Nullable Map<String, String> map) {
        Role role = (Role)this.getOfID(string);
        if (role == null) {
            AuditHelper.onAuditModifyFailure((ObjectType)Role.OT, (String)"set-all", (Object[])new Object[]{string, "no-such-role-id"});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = role.setName(string2);
            eChange = eChange.or((IChangeIndicator)role.setDescription(string3));
            eChange = eChange.or((IChangeIndicator)role.attrs().setAll(map));
            if (eChange.isUnchanged()) {
                EChange eChange2 = EChange.UNCHANGED;
                return eChange2;
            }
            BusinessObjectHelper.setLastModificationNow(role);
            this.internalUpdateItem((IHasID)role);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess((ObjectType)Role.OT, (String)"set-all", (Object[])new Object[]{role.getID(), string2, string3, map});
        this.m_aCallbacks.forEach(iRoleModificationCallback -> iRoleModificationCallback.onRoleUpdated(string));
        return EChange.CHANGED;
    }
}

