/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.user;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.id.IHasID;
import com.helger.commons.state.EChange;
import com.helger.commons.state.IChangeIndicator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.type.ObjectType;
import com.helger.dao.DAOException;
import com.helger.photon.app.dao.AbstractPhotonMapBasedWALDAO;
import com.helger.photon.audit.AuditHelper;
import com.helger.photon.security.object.BusinessObjectHelper;
import com.helger.photon.security.password.GlobalPasswordSettings;
import com.helger.photon.security.user.IUser;
import com.helger.photon.security.user.IUserManager;
import com.helger.photon.security.user.IUserModificationCallback;
import com.helger.photon.security.user.User;
import com.helger.security.password.hash.PasswordHash;
import com.helger.security.password.salt.IPasswordSalt;
import com.helger.security.password.salt.PasswordSalt;
import com.helger.tenancy.IBusinessObject;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class UserManager
extends AbstractPhotonMapBasedWALDAO<IUser, User>
implements IUserManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserManager.class);
    private final CallbackList<IUserModificationCallback> m_aCallbacks = new CallbackList();

    public UserManager(@Nonnull @Nonempty String string) throws DAOException {
        super(User.class, string);
    }

    @Nonnull
    public static User createDefaultUserAdministrator() {
        return User.createdPredefinedUser("admin", "Admin", "admin@helger.com", GlobalPasswordSettings.createUserDefaultPasswordHash((IPasswordSalt)PasswordSalt.createRandom(), "password"), "Administrator", null, null, null, null, false);
    }

    @Nonnull
    public static User createDefaultUserUser() {
        return User.createdPredefinedUser("user", "User", "user@helger.com", GlobalPasswordSettings.createUserDefaultPasswordHash((IPasswordSalt)PasswordSalt.createRandom(), "user"), "User", null, null, null, null, false);
    }

    @Nonnull
    public static User createDefaultUserGuest() {
        return User.createdPredefinedUser("guest", "Guest", "guest@helger.com", GlobalPasswordSettings.createUserDefaultPasswordHash((IPasswordSalt)PasswordSalt.createRandom(), "guest"), "Guest", null, null, null, null, false);
    }

    @Override
    public void createDefaultsForTest() {
        if (!this.containsWithID("admin")) {
            this.m_aRWLock.writeLocked(() -> {
                User cfr_ignored_0 = (User)this.internalCreateItem((IHasID)UserManager.createDefaultUserAdministrator());
            });
        }
        if (!this.containsWithID("user")) {
            this.m_aRWLock.writeLocked(() -> {
                User cfr_ignored_0 = (User)this.internalCreateItem((IHasID)UserManager.createDefaultUserUser());
            });
        }
        if (!this.containsWithID("guest")) {
            this.m_aRWLock.writeLocked(() -> {
                User cfr_ignored_0 = (User)this.internalCreateItem((IHasID)UserManager.createDefaultUserGuest());
            });
        }
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final CallbackList<IUserModificationCallback> userModificationCallbacks() {
        return this.m_aCallbacks;
    }

    @Override
    @Nullable
    public IUser createNewUser(@Nonnull @Nonempty String string, @Nullable String string2, @Nonnull String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable Locale locale, @Nullable Map<String, String> map, boolean bl) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"LoginName");
        ValueEnforcer.notNull((Object)string3, (String)"PlainTextPassword");
        if (this.getUserOfLoginName(string) != null) {
            AuditHelper.onAuditCreateFailure((ObjectType)User.OT, (Object[])new Object[]{string, "login-name-already-in-use"});
            return null;
        }
        User user = new User(string, string2, GlobalPasswordSettings.createUserDefaultPasswordHash((IPasswordSalt)PasswordSalt.createRandom(), string3), string4, string5, string6, locale, map, bl);
        this.m_aRWLock.writeLocked(() -> {
            User cfr_ignored_0 = (User)this.internalCreateItem((IHasID)user);
        });
        AuditHelper.onAuditCreateSuccess((ObjectType)User.OT, (Object[])new Object[]{user.getID(), string, string2, string4, string5, string6, locale, map, bl});
        this.m_aCallbacks.forEach(iUserModificationCallback -> iUserModificationCallback.onUserCreated(user, false));
        return user;
    }

    @Override
    @Nullable
    public IUser createPredefinedUser(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable String string3, @Nonnull String string4, @Nullable String string5, @Nullable String string6, @Nullable String string7, @Nullable Locale locale, @Nullable Map<String, String> map, boolean bl) {
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"LoginName");
        ValueEnforcer.notNull((Object)string4, (String)"PlainTextPassword");
        if (this.getUserOfLoginName(string2) != null) {
            AuditHelper.onAuditCreateFailure((ObjectType)User.OT, (Object[])new Object[]{string2, "predefined-user", "login-name-already-in-use"});
            return null;
        }
        User user = User.createdPredefinedUser(string, string2, string3, GlobalPasswordSettings.createUserDefaultPasswordHash((IPasswordSalt)PasswordSalt.createRandom(), string4), string5, string6, string7, locale, map, bl);
        this.m_aRWLock.writeLocked(() -> {
            User cfr_ignored_0 = (User)this.internalCreateItem((IHasID)user);
        });
        AuditHelper.onAuditCreateSuccess((ObjectType)User.OT, (Object[])new Object[]{user.getID(), "predefined-user", string2, string3, string5, string6, string7, locale, map, bl});
        this.m_aCallbacks.forEach(iUserModificationCallback -> iUserModificationCallback.onUserCreated(user, true));
        return user;
    }

    @Override
    @Nullable
    public IUser getUserOfID(@Nullable String string) {
        return (IUser)this.getOfID(string);
    }

    @Override
    @Nullable
    public IUser getUserOfLoginName(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        return (IUser)this.findFirst(iUser -> iUser.getLoginName().equals(string));
    }

    @Override
    @Nullable
    public IUser getUserOfEmailAddress(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        return (IUser)this.findFirst(iUser -> string.equals(iUser.getEmailAddress()));
    }

    @Override
    @Nullable
    public IUser getUserOfEmailAddressIgnoreCase(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        return (IUser)this.findFirst(iUser -> string.equalsIgnoreCase(iUser.getEmailAddress()));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IUser> getAllActiveUsers() {
        return this.getAll(iUser -> iUser.isNotDeleted() && iUser.isEnabled());
    }

    @Override
    @Nonnegative
    public long getActiveUserCount() {
        return this.getCount(iUser -> iUser.isNotDeleted() && iUser.isEnabled());
    }

    @Override
    public boolean containsAnyActiveUser() {
        return this.containsAny(iUser -> iUser.isNotDeleted() && iUser.isEnabled());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IUser> getAllDisabledUsers() {
        return this.getAll(iUser -> iUser.isNotDeleted() && iUser.isDisabled());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IUser> getAllNotDeletedUsers() {
        return this.getAll(IBusinessObject::isNotDeleted);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IUser> getAllDeletedUsers() {
        return this.getAll(IBusinessObject::isDeleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange setUserData(@Nullable String string, @Nonnull @Nonempty String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable Locale locale, @Nullable Map<String, String> map, boolean bl) {
        User user = (User)this.getOfID(string);
        if (user == null) {
            AuditHelper.onAuditModifyFailure((ObjectType)User.OT, (String)"set-all", (Object[])new Object[]{string, "no-such-id"});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = user.setLoginName(string2);
            eChange = eChange.or((IChangeIndicator)user.setEmailAddress(string3));
            eChange = eChange.or((IChangeIndicator)user.setFirstName(string4));
            eChange = eChange.or((IChangeIndicator)user.setLastName(string5));
            eChange = eChange.or((IChangeIndicator)user.setDescription(string6));
            eChange = eChange.or((IChangeIndicator)user.setDesiredLocale(locale));
            eChange = eChange.or((IChangeIndicator)user.setDisabled(bl));
            eChange = eChange.or((IChangeIndicator)user.attrs().setAll(map));
            if (eChange.isUnchanged()) {
                EChange eChange2 = EChange.UNCHANGED;
                return eChange2;
            }
            BusinessObjectHelper.setLastModificationNow(user);
            this.internalUpdateItem((IHasID)user);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess((ObjectType)User.OT, (String)"set-all", (Object[])new Object[]{string, string2, string3, string4, string5, string6, locale, map, bl});
        this.m_aCallbacks.forEach(iUserModificationCallback -> iUserModificationCallback.onUserUpdated(string));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange setUserPassword(@Nullable String string, @Nonnull String string2) {
        User user = (User)this.getOfID(string);
        if (user == null) {
            AuditHelper.onAuditModifyFailure((ObjectType)User.OT, (String)"set-password", (Object[])new Object[]{string, "no-such-id"});
            return EChange.UNCHANGED;
        }
        PasswordHash passwordHash = GlobalPasswordSettings.createUserDefaultPasswordHash((IPasswordSalt)PasswordSalt.createRandom(), string2);
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = user.setPasswordHash(passwordHash);
            if (eChange.isUnchanged()) {
                EChange eChange2 = EChange.UNCHANGED;
                return eChange2;
            }
            BusinessObjectHelper.setLastModificationNow(user);
            this.internalUpdateItem((IHasID)user);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess((ObjectType)User.OT, (String)"set-password", (Object[])new Object[]{string});
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("The password of user '" + string + "' was changed");
        }
        this.m_aCallbacks.forEach(iUserModificationCallback -> iUserModificationCallback.onUserPasswordChanged(string));
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public EChange updateUserLastLogin(@Nullable String string) {
        User user = (User)this.getOfID(string);
        if (user == null) {
            AuditHelper.onAuditModifyFailure((ObjectType)User.OT, (String)"update-last-login", (Object[])new Object[]{string, "no-such-id"});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            user.onSuccessfulLogin();
            this.internalUpdateItem((IHasID)user);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess((ObjectType)User.OT, (String)"update-last-login", (Object[])new Object[]{string});
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public EChange updateUserLastFailedLogin(@Nullable String string) {
        User user = (User)this.getOfID(string);
        if (user == null) {
            AuditHelper.onAuditModifyFailure((ObjectType)User.OT, (String)"update-last-failed-login", (Object[])new Object[]{string, "no-such-id"});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            user.onFailedLogin();
            this.internalUpdateItem((IHasID)user);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess((ObjectType)User.OT, (String)"update-last-failed-login", (Object[])new Object[]{string});
        this.m_aCallbacks.forEach(iUserModificationCallback -> iUserModificationCallback.onUserLastFailedLoginUpdated(string));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange deleteUser(@Nullable String string) {
        User user = (User)this.getOfID(string);
        if (user == null) {
            AuditHelper.onAuditDeleteFailure((ObjectType)User.OT, (Object[])new Object[]{string, "no-such-id"});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (BusinessObjectHelper.setDeletionNow(user).isUnchanged()) {
                AuditHelper.onAuditDeleteFailure((ObjectType)User.OT, (Object[])new Object[]{string, "already-deleted"});
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.internalMarkItemDeleted((IHasID)user);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditDeleteSuccess((ObjectType)User.OT, (Object[])new Object[]{string});
        this.m_aCallbacks.forEach(iUserModificationCallback -> iUserModificationCallback.onUserDeleted(string));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange undeleteUser(@Nullable String string) {
        User user = (User)this.getOfID(string);
        if (user == null) {
            AuditHelper.onAuditUndeleteFailure((ObjectType)User.OT, (Object[])new Object[]{string, "no-such-id"});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (BusinessObjectHelper.setUndeletionNow(user).isUnchanged()) {
                AuditHelper.onAuditUndeleteFailure((ObjectType)User.OT, (Object[])new Object[]{string, "not-deleted"});
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.internalMarkItemUndeleted((IHasID)user);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditUndeleteSuccess((ObjectType)User.OT, (Object[])new Object[]{string});
        this.m_aCallbacks.forEach(iUserModificationCallback -> iUserModificationCallback.onUserUndeleted(string));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange disableUser(@Nullable String string) {
        User user = (User)this.getOfID(string);
        if (user == null) {
            AuditHelper.onAuditModifyFailure((ObjectType)User.OT, (String)"disable", (Object[])new Object[]{string, "no-such-id"});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (user.setDisabled(true).isUnchanged()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            BusinessObjectHelper.setLastModificationNow(user);
            this.internalUpdateItem((IHasID)user);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess((ObjectType)User.OT, (String)"disable", (Object[])new Object[]{string});
        this.m_aCallbacks.forEach(iUserModificationCallback -> iUserModificationCallback.onUserEnabled(string, false));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange enableUser(@Nullable String string) {
        User user = (User)this.getOfID(string);
        if (user == null) {
            AuditHelper.onAuditModifyFailure((ObjectType)User.OT, (String)"enable", (Object[])new Object[]{string, "no-such-id"});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (user.setDisabled(false).isUnchanged()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            BusinessObjectHelper.setLastModificationNow(user);
            this.internalUpdateItem((IHasID)user);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess((ObjectType)User.OT, (String)"enable", (Object[])new Object[]{string});
        this.m_aCallbacks.forEach(iUserModificationCallback -> iUserModificationCallback.onUserEnabled(string, true));
        return EChange.CHANGED;
    }
}

