/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.usergroup;

import com.helger.commons.string.StringHelper;
import com.helger.photon.security.object.AbstractBusinessObjectMicroTypeConverter;
import com.helger.photon.security.usergroup.UserGroup;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import com.helger.xml.microdom.util.MicroHelper;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class UserGroupMicroTypeConverter
extends AbstractBusinessObjectMicroTypeConverter<UserGroup> {
    private static final IMicroQName ATTR_NAME = new MicroQName("name");
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final String ELEMENT_USER = "user";
    private static final String ELEMENT_ROLE = "role";

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull UserGroup userGroup, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        UserGroupMicroTypeConverter.setObjectFields(userGroup, (IMicroElement)microElement);
        microElement.setAttribute(ATTR_NAME, userGroup.getName());
        if (StringHelper.hasText((String)userGroup.getDescription())) {
            microElement.appendElement(string, ELEMENT_DESCRIPTION).appendText((CharSequence)userGroup.getDescription());
        }
        for (String string3 : userGroup.getAllContainedUserIDs().getSorted(Comparator.naturalOrder())) {
            microElement.appendElement(string, ELEMENT_USER).setAttribute(ATTR_ID, string3);
        }
        for (String string3 : userGroup.getAllContainedRoleIDs().getSorted(Comparator.naturalOrder())) {
            microElement.appendElement(string, ELEMENT_ROLE).setAttribute(ATTR_ID, string3);
        }
        return microElement;
    }

    @Nonnull
    public UserGroup convertToNative(@Nonnull IMicroElement iMicroElement) {
        String string = iMicroElement.getAttributeValue(ATTR_NAME);
        String string2 = MicroHelper.getChildTextContentTrimmed((IMicroElement)iMicroElement, (String)ELEMENT_DESCRIPTION);
        UserGroup userGroup = new UserGroup(UserGroupMicroTypeConverter.getStubObject(iMicroElement), string, string2);
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements(ELEMENT_USER)) {
            userGroup.assignUser(iMicroElement2.getAttributeValue(ATTR_ID));
        }
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements(ELEMENT_ROLE)) {
            userGroup.assignRole(iMicroElement2.getAttributeValue(ATTR_ID));
        }
        return userGroup;
    }
}

