/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.auth;

import com.helger.commons.annotation.IsSPIImplementation;
import com.helger.photon.security.login.ELoginResult;
import com.helger.photon.security.mgr.PhotonSecurityManager;
import com.helger.photon.security.token.credentials.ITokenCredentials;
import com.helger.photon.security.token.user.IUserToken;
import com.helger.photon.security.token.user.IUserTokenManager;
import com.helger.security.authentication.credentials.IAuthCredentialValidatorSPI;
import com.helger.security.authentication.credentials.IAuthCredentials;
import javax.annotation.Nonnull;

@IsSPIImplementation
public final class UserTokenAuthCredentialValidatorSPI
implements IAuthCredentialValidatorSPI {
    public boolean supportsCredentials(@Nonnull IAuthCredentials iAuthCredentials) {
        return iAuthCredentials instanceof ITokenCredentials;
    }

    @Nonnull
    public ELoginResult validateCredentials(@Nonnull IAuthCredentials iAuthCredentials) {
        ITokenCredentials iTokenCredentials = (ITokenCredentials)iAuthCredentials;
        IUserTokenManager iUserTokenManager = PhotonSecurityManager.getUserTokenMgr();
        IUserToken iUserToken = iUserTokenManager.getUserTokenOfTokenString(iTokenCredentials.getTokenString());
        if (iUserToken == null) {
            return ELoginResult.TOKEN_NOT_EXISTING;
        }
        if (iUserToken.isDeleted()) {
            return ELoginResult.TOKEN_NOT_EXISTING;
        }
        return ELoginResult.SUCCESS;
    }
}

