/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.lock;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.security.lock.ILockInfo;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class LockInfo
implements ILockInfo {
    private final String m_sUserID;
    private final LocalDateTime m_aLockTime;

    public LockInfo(@Nonnull @Nonempty String string) {
        this.m_sUserID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"UserID");
        this.m_aLockTime = PDTFactory.getCurrentLocalDateTime();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getLockUserID() {
        return this.m_sUserID;
    }

    @Override
    @Nonnull
    public LocalDateTime getLockDateTime() {
        return this.m_aLockTime;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        LockInfo lockInfo = (LockInfo)object;
        return this.m_sUserID.equals(lockInfo.m_sUserID) && this.m_aLockTime.equals(lockInfo.m_aLockTime);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sUserID).append((Object)this.m_aLockTime).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("userID", (Object)this.m_sUserID).append("lockTime", (Object)this.m_aLockTime).getToString();
    }
}

