/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.mgr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.callback.ICallback;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.lang.ClassHelper;
import com.helger.dao.DAOException;
import com.helger.photon.audit.AuditHelper;
import com.helger.photon.audit.AuditManager;
import com.helger.photon.audit.IAuditManager;
import com.helger.photon.audit.IAuditor;
import com.helger.photon.security.lock.DefaultLockManager;
import com.helger.photon.security.lock.ObjectLockManager;
import com.helger.photon.security.login.ELoginResult;
import com.helger.photon.security.login.IUserLoginCallback;
import com.helger.photon.security.login.LoggedInUserManager;
import com.helger.photon.security.login.LoginInfo;
import com.helger.photon.security.role.IRoleManager;
import com.helger.photon.security.role.RoleManager;
import com.helger.photon.security.token.user.IUserTokenManager;
import com.helger.photon.security.token.user.UserTokenManager;
import com.helger.photon.security.user.IUserManager;
import com.helger.photon.security.user.UserManager;
import com.helger.photon.security.usergroup.IUserGroupManager;
import com.helger.photon.security.usergroup.UserGroupManager;
import com.helger.scope.IScope;
import com.helger.scope.singleton.AbstractGlobalSingleton;
import com.helger.security.authentication.subject.user.ICurrentUserIDProvider;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PhotonSecurityManager
extends AbstractGlobalSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhotonSecurityManager.class);
    private static final AtomicBoolean INITED = new AtomicBoolean(false);
    private static IFactory s_aFactory = new FactoryXML();
    private IAuditManager m_aAuditMgr;
    private IUserManager m_aUserMgr;
    private IRoleManager m_aRoleMgr;
    private IUserGroupManager m_aUserGroupMgr;
    private IUserTokenManager m_aUserTokenMgr;

    public static boolean isAlreadyInitialized() {
        return INITED.get();
    }

    @Nonnull
    public static IFactory getFactory() {
        return s_aFactory;
    }

    public static void setFactory(@Nonnull IFactory iFactory) {
        ValueEnforcer.notNull((Object)iFactory, (String)"Factory");
        if (PhotonSecurityManager.isAlreadyInitialized()) {
            LOGGER.error("Setting the PhotonSecurityManager factory after initialization has no effect and is ignored!");
        } else {
            s_aFactory = iFactory;
            LOGGER.info("Setting the PhotonSecurityManager to " + iFactory.toString());
        }
    }

    @Deprecated(forRemoval=false)
    @UsedViaReflection
    public PhotonSecurityManager() {
    }

    private void _initCallbacks() {
        LoggedInUserManager.getInstance().userLoginCallbacks().add((ICallback)new IUserLoginCallback(){

            @Override
            public void onUserLogin(@Nonnull LoginInfo loginInfo) {
                PhotonSecurityManager.this.m_aUserMgr.updateUserLastLogin(loginInfo.getUserID());
            }

            @Override
            public void onUserLoginError(@Nonnull @Nonempty String string, @Nonnull ELoginResult eLoginResult) {
                if (eLoginResult == ELoginResult.INVALID_PASSWORD) {
                    PhotonSecurityManager.this.m_aUserMgr.updateUserLastFailedLogin(string);
                }
            }
        });
    }

    protected void onAfterInstantiation(@Nonnull IScope iScope) {
        try {
            this.m_aAuditMgr = s_aFactory.createAuditManager();
            AuditHelper.setAuditor((IAuditor)this.m_aAuditMgr.getAuditor());
            AuditHelper.onAuditExecuteSuccess((String)"audit-initialized", (Object[])new Object[0]);
            this.m_aUserMgr = s_aFactory.createUserMgr();
            this.m_aRoleMgr = s_aFactory.createRoleMgr();
            this.m_aUserGroupMgr = s_aFactory.createUserGroupMgr(this.m_aUserMgr, this.m_aRoleMgr);
            this.m_aUserTokenMgr = s_aFactory.createUserTokenMgr(this.m_aUserMgr);
            INITED.set(true);
            this._initCallbacks();
            LOGGER.info(ClassHelper.getClassLocalName((Object)((Object)this)) + " was initialized");
        }
        catch (Exception exception) {
            throw new InitializationException("Failed to init " + ClassHelper.getClassLocalName((Object)((Object)this)), (Throwable)exception);
        }
    }

    protected void onBeforeDestroy(@Nonnull IScope iScope) {
        if (this.m_aAuditMgr != null) {
            AuditHelper.onAuditExecuteSuccess((String)"audit-shutdown", (Object[])new Object[0]);
        }
    }

    protected void onDestroy(@Nonnull IScope iScope) {
        if (this.m_aAuditMgr != null) {
            AuditHelper.setDefaultAuditor();
            this.m_aAuditMgr.stop();
        }
    }

    @Nonnull
    public static PhotonSecurityManager getInstance() {
        return (PhotonSecurityManager)PhotonSecurityManager.getGlobalSingleton(PhotonSecurityManager.class);
    }

    @Nonnull
    public static IAuditManager getAuditMgr() {
        return PhotonSecurityManager.getInstance().m_aAuditMgr;
    }

    @Nonnull
    public static DefaultLockManager<String> getLockMgr() {
        return ObjectLockManager.getInstance().getDefaultLockMgr();
    }

    @Nonnull
    public static IRoleManager getRoleMgr() {
        return PhotonSecurityManager.getInstance().m_aRoleMgr;
    }

    @Nonnull
    public static IUserManager getUserMgr() {
        return PhotonSecurityManager.getInstance().m_aUserMgr;
    }

    @Nonnull
    public static IUserGroupManager getUserGroupMgr() {
        return PhotonSecurityManager.getInstance().m_aUserGroupMgr;
    }

    @Nonnull
    public static IUserTokenManager getUserTokenMgr() {
        return PhotonSecurityManager.getInstance().m_aUserTokenMgr;
    }

    @Immutable
    public static class FactoryXML
    implements IFactory {
        public static final String DIRECTORY_AUDITS = "audits/";
        public static final String DIRECTORY_SECURITY = "security/";
        public static final String FILENAME_USERS_XML = "users.xml";
        public static final String FILENAME_ROLES_XML = "roles.xml";
        public static final String FILENAME_USERGROUPS_XML = "usergroups.xml";
        public static final String FILENAME_USERTOKENS_XML = "usertokens.xml";

        @Override
        @Nonnull
        public IAuditManager createAuditManager() throws DAOException {
            return new AuditManager(DIRECTORY_AUDITS, (ICurrentUserIDProvider)LoggedInUserManager.getInstance());
        }

        @Override
        @Nonnull
        public IUserManager createUserMgr() throws DAOException {
            return new UserManager("security/users.xml");
        }

        @Override
        @Nonnull
        public IRoleManager createRoleMgr() throws DAOException {
            return new RoleManager("security/roles.xml");
        }

        @Override
        @Nonnull
        public IUserGroupManager createUserGroupMgr(@Nonnull IUserManager iUserManager, @Nonnull IRoleManager iRoleManager) throws DAOException {
            return new UserGroupManager("security/usergroups.xml", iUserManager, iRoleManager);
        }

        @Override
        @Nonnull
        public IUserTokenManager createUserTokenMgr(@Nonnull IUserManager iUserManager) throws DAOException {
            return new UserTokenManager("security/usertokens.xml");
        }
    }

    public static interface IFactory {
        @Nonnull
        public IAuditManager createAuditManager() throws Exception;

        @Nonnull
        public IUserManager createUserMgr() throws Exception;

        @Nonnull
        public IRoleManager createRoleMgr() throws Exception;

        @Nonnull
        public IUserGroupManager createUserGroupMgr(@Nonnull IUserManager var1, @Nonnull IRoleManager var2) throws Exception;

        @Nonnull
        public IUserTokenManager createUserTokenMgr(@Nonnull IUserManager var1) throws Exception;
    }
}

