/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.password.hash;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsCollection;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.security.password.hash.IPasswordHashCreator;
import com.helger.security.password.hash.PasswordHash;
import com.helger.security.password.salt.IPasswordSalt;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class PasswordHashCreatorManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordHashCreatorManager.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, IPasswordHashCreator> m_aPasswordHashCreators = new CommonsHashMap();
    @GuardedBy(value="m_aRWLock")
    private IPasswordHashCreator m_aDefaultPasswordHashCreator;

    public void registerPasswordHashCreator(@Nonnull IPasswordHashCreator iPasswordHashCreator) {
        ValueEnforcer.notNull((Object)iPasswordHashCreator, (String)"PasswordHashCreator");
        String string = iPasswordHashCreator.getAlgorithmName();
        if (StringHelper.hasNoText((String)string)) {
            throw new IllegalArgumentException("PasswordHashCreator algorithm '" + iPasswordHashCreator + "' is empty!");
        }
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_aPasswordHashCreators.containsKey((Object)string)) {
                throw new IllegalArgumentException("Another PasswordHashCreator for algorithm '" + string + "' is already registered!");
            }
            this.m_aPasswordHashCreators.put((Object)string, (Object)iPasswordHashCreator);
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Registered password hash creator algorithm '" + string + "' to " + iPasswordHashCreator);
        }
    }

    public void unregisterPasswordHashCreator(@Nullable IPasswordHashCreator iPasswordHashCreator) {
        String string;
        if (iPasswordHashCreator != null && StringHelper.hasText((String)(string = iPasswordHashCreator.getAlgorithmName()))) {
            this.m_aRWLock.writeLocked(() -> {
                if (this.m_aPasswordHashCreators.remove((Object)string) != null) {
                    LOGGER.info("Unregistered password hash creator algorithm '" + string + "'");
                }
            });
        }
    }

    @Nullable
    public IPasswordHashCreator getPasswordHashCreatorOfAlgorithm(@Nullable String string) {
        return (IPasswordHashCreator)this.m_aRWLock.readLockedGet(() -> (IPasswordHashCreator)this.m_aPasswordHashCreators.get((Object)string));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllPasswordHashCreatorAlgorithms() {
        return (ICommonsSet)this.m_aRWLock.readLockedGet(() -> this.m_aPasswordHashCreators.copyOfKeySet());
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsCollection<IPasswordHashCreator> getAllPasswordHashCreators() {
        return (ICommonsCollection)this.m_aRWLock.readLockedGet(() -> this.m_aPasswordHashCreators.copyOfValues());
    }

    public void setDefaultPasswordHashCreatorAlgorithm(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Algorithm");
        this.m_aRWLock.writeLocked(() -> {
            IPasswordHashCreator iPasswordHashCreator = (IPasswordHashCreator)this.m_aPasswordHashCreators.get((Object)string);
            if (iPasswordHashCreator == null) {
                throw new IllegalArgumentException("No PasswordHashCreator registered for algorithm '" + string + "'");
            }
            this.m_aDefaultPasswordHashCreator = iPasswordHashCreator;
        });
        LOGGER.info("Default PasswordHashCreator algorithm set to '" + string + "'");
    }

    @Nonnull
    public IPasswordHashCreator getDefaultPasswordHashCreator() {
        IPasswordHashCreator iPasswordHashCreator = (IPasswordHashCreator)this.m_aRWLock.readLockedGet(() -> this.m_aDefaultPasswordHashCreator);
        if (iPasswordHashCreator == null) {
            throw new IllegalStateException("No default PasswordHashCreator present!");
        }
        return iPasswordHashCreator;
    }

    @Nonnull
    public String getDefaultPasswordHashCreatorAlgorithmName() {
        return this.getDefaultPasswordHashCreator().getAlgorithmName();
    }

    @Nonnull
    public PasswordHash createUserDefaultPasswordHash(@Nullable IPasswordSalt iPasswordSalt, @Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"PlainTextPassword");
        IPasswordHashCreator iPasswordHashCreator = this.getDefaultPasswordHashCreator();
        String string2 = iPasswordHashCreator.createPasswordHash(iPasswordSalt, string);
        return new PasswordHash(iPasswordHashCreator.getAlgorithmName(), iPasswordSalt, string2);
    }

    @Nonnull
    public PasswordHash createUserPasswordHash(@Nonnull @Nonempty String string, @Nullable IPasswordSalt iPasswordSalt, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)string2, (String)"PlainTextPassword");
        IPasswordHashCreator iPasswordHashCreator = this.getPasswordHashCreatorOfAlgorithm(string);
        if (iPasswordHashCreator == null) {
            throw new IllegalArgumentException("No password hash creator for algorithm '" + string + "' registered!");
        }
        String string3 = iPasswordHashCreator.createPasswordHash(iPasswordSalt, string2);
        return new PasswordHash(string, iPasswordSalt, string3);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("map", this.m_aPasswordHashCreators).append("default", (Object)this.m_aDefaultPasswordHashCreator).getToString();
    }
}

