/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.token.user;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.string.StringHelper;
import com.helger.photon.security.mgr.PhotonSecurityManager;
import com.helger.photon.security.object.AbstractBusinessObjectMicroTypeConverter;
import com.helger.photon.security.token.accesstoken.AccessToken;
import com.helger.photon.security.token.accesstoken.IAccessToken;
import com.helger.photon.security.token.user.UserToken;
import com.helger.photon.security.user.IUser;
import com.helger.photon.security.user.IUserManager;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import com.helger.xml.microdom.util.MicroHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class UserTokenMicroTypeConverter
extends AbstractBusinessObjectMicroTypeConverter<UserToken> {
    private static final String ELEMENT_ACCESS_TOKEN = "accesstoken";
    private static final IMicroQName ATTR_USER_ID = new MicroQName("userid");
    private static final String ELEMENT_DESCRIPTION = "description";

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull UserToken userToken, @Nullable String string, @Nonnull @Nonempty String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        UserTokenMicroTypeConverter.setObjectFields(userToken, (IMicroElement)microElement);
        for (IAccessToken iAccessToken : userToken.getAccessTokenList().getAllAccessTokens()) {
            microElement.appendChild((IMicroNode)MicroTypeConverter.convertToMicroElement((Object)iAccessToken, (String)string, (String)ELEMENT_ACCESS_TOKEN));
        }
        microElement.setAttribute(ATTR_USER_ID, (String)userToken.getUser().getID());
        if (StringHelper.hasText((String)userToken.getDescription())) {
            microElement.appendElement(string, ELEMENT_DESCRIPTION).appendText((CharSequence)userToken.getDescription());
        }
        return microElement;
    }

    @Nonnull
    public UserToken convertToNative(@Nonnull IMicroElement iMicroElement) {
        Object object2;
        IUserManager iUserManager = PhotonSecurityManager.getUserMgr();
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (Object object2 : iMicroElement.getAllChildElements(ELEMENT_ACCESS_TOKEN)) {
            commonsArrayList.add((Object)((AccessToken)MicroTypeConverter.convertToNative((IMicroElement)object2, AccessToken.class)));
        }
        String string = iMicroElement.getAttributeValue(ATTR_USER_ID);
        object2 = iUserManager.getUserOfID(string);
        if (object2 == null) {
            throw new IllegalStateException("Failed to resolve user with ID '" + (String)string + "'");
        }
        String string2 = MicroHelper.getChildTextContentTrimmed((IMicroElement)iMicroElement, (String)ELEMENT_DESCRIPTION);
        return new UserToken(UserTokenMicroTypeConverter.getStubObject(iMicroElement), (List<AccessToken>)commonsArrayList, (IUser)object2, string2);
    }
}

