/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.user.credentials;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsCollection;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.security.user.IUser;
import com.helger.photon.security.user.credentials.IUserPasswordCredentials;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class UserPasswordCredentials
implements IUserPasswordCredentials {
    private final IUser m_aUser;
    private final String m_sPassword;
    private final ICommonsList<String> m_aRequiredRoles;

    public UserPasswordCredentials(@Nullable IUser iUser, @Nullable String string, @Nullable Collection<String> collection) {
        this.m_aUser = iUser;
        this.m_sPassword = string;
        this.m_aRequiredRoles = new CommonsArrayList(collection);
    }

    @Override
    @Nullable
    public final IUser getUser() {
        return this.m_aUser;
    }

    @Override
    @Nullable
    public final String getPassword() {
        return this.m_sPassword;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsCollection<String> getAllRequiredRoles() {
        return (ICommonsCollection)this.m_aRequiredRoles.getClone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        UserPasswordCredentials userPasswordCredentials = (UserPasswordCredentials)object;
        return EqualsHelper.equals((Object)this.m_aUser, (Object)userPasswordCredentials.m_aUser) && EqualsHelper.equals((Object)this.m_sPassword, (Object)userPasswordCredentials.m_sPassword) && this.m_aRequiredRoles.equals(userPasswordCredentials.m_aRequiredRoles);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aUser).append((Object)this.m_sPassword).append(this.m_aRequiredRoles).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("User", (Object)this.m_aUser).appendPassword("Password").append("RequiredRoles", this.m_aRequiredRoles).getToString();
    }
}

