/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.core;

import com.helger.quartz.IJobDetail;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.IJobListener;
import com.helger.quartz.ISchedulerListener;
import com.helger.quartz.ITrigger;
import com.helger.quartz.JobExecutionException;
import com.helger.quartz.core.ISampledStatistics;
import com.helger.quartz.core.QuartzScheduler;
import com.helger.quartz.utils.counter.CounterConfig;
import com.helger.quartz.utils.counter.CounterManager;
import com.helger.quartz.utils.counter.ICounterManager;
import com.helger.quartz.utils.counter.sampled.ISampledCounter;
import com.helger.quartz.utils.counter.sampled.SampledCounterConfig;
import com.helger.quartz.utils.counter.sampled.SampledRateCounterConfig;
import java.util.Timer;
import javax.annotation.Nonnull;

public class SampledStatistics
implements ISampledStatistics,
IJobListener,
ISchedulerListener {
    public static final String NAME = "QuartzSampledStatistics";
    private static final int DEFAULT_HISTORY_SIZE = 30;
    private static final int DEFAULT_INTERVAL_SECS = 1;
    private static final SampledCounterConfig DEFAULT_SAMPLED_COUNTER_CONFIG = new SampledCounterConfig(1, 30, true, 0L);
    private static final SampledRateCounterConfig DEFAULT_SAMPLED_RATE_COUNTER_CONFIG = new SampledRateCounterConfig(1, 30, true);
    private final ICounterManager m_aCounterManager = new CounterManager(new Timer("QuartzSampledStatisticsTimer"));
    private final ISampledCounter m_aJobsScheduledCount = this.createSampledCounter(DEFAULT_SAMPLED_COUNTER_CONFIG);
    private final ISampledCounter m_aJobsExecutingCount = this.createSampledCounter(DEFAULT_SAMPLED_COUNTER_CONFIG);
    private final ISampledCounter m_aJobsCompletedCount = this.createSampledCounter(DEFAULT_SAMPLED_COUNTER_CONFIG);

    SampledStatistics(@Nonnull QuartzScheduler quartzScheduler) {
        quartzScheduler.addInternalSchedulerListener(this);
        quartzScheduler.addInternalJobListener(this);
    }

    @Override
    public void shutdown() {
        this.m_aCounterManager.shutdown(true);
    }

    private ISampledCounter createSampledCounter(CounterConfig counterConfig) {
        return (ISampledCounter)this.m_aCounterManager.createCounter(counterConfig);
    }

    public void clearStatistics() {
        this.m_aJobsScheduledCount.getAndReset();
        this.m_aJobsExecutingCount.getAndReset();
        this.m_aJobsCompletedCount.getAndReset();
    }

    @Override
    public long getJobsCompletedMostRecentSample() {
        return this.m_aJobsCompletedCount.getMostRecentSample().getCounterValue();
    }

    @Override
    public long getJobsExecutingMostRecentSample() {
        return this.m_aJobsExecutingCount.getMostRecentSample().getCounterValue();
    }

    @Override
    public long getJobsScheduledMostRecentSample() {
        return this.m_aJobsScheduledCount.getMostRecentSample().getCounterValue();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void jobScheduled(ITrigger iTrigger) {
        this.m_aJobsScheduledCount.increment();
    }

    @Override
    public void jobExecutionVetoed(IJobExecutionContext iJobExecutionContext) {
    }

    @Override
    public void jobToBeExecuted(IJobExecutionContext iJobExecutionContext) {
        this.m_aJobsExecutingCount.increment();
    }

    @Override
    public void jobWasExecuted(IJobExecutionContext iJobExecutionContext, JobExecutionException jobExecutionException) {
        this.m_aJobsCompletedCount.increment();
    }

    @Override
    public void jobAdded(IJobDetail iJobDetail) {
    }
}

