/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.impl.calendar;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.quartz.ICalendar;
import com.helger.quartz.impl.calendar.AbstractCalendar;
import com.helger.quartz.impl.calendar.CalendarComparator;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AnnualCalendar
extends AbstractCalendar<AnnualCalendar> {
    private final ICommonsList<Calendar> m_aExcludeDays = new CommonsArrayList();
    private boolean m_bDataSorted = false;

    public AnnualCalendar(@Nonnull AnnualCalendar annualCalendar) {
        super(annualCalendar);
        this.m_aExcludeDays.addAll(annualCalendar.m_aExcludeDays);
    }

    public AnnualCalendar() {
        this(null, null);
    }

    public AnnualCalendar(ICalendar iCalendar) {
        this(iCalendar, null);
    }

    public AnnualCalendar(TimeZone timeZone) {
        this(null, timeZone);
    }

    public AnnualCalendar(ICalendar iCalendar, TimeZone timeZone) {
        super(iCalendar, timeZone);
    }

    @ReturnsMutableObject
    public ICommonsList<Calendar> getDaysExcluded() {
        return this.m_aExcludeDays;
    }

    public boolean isDayExcluded(@Nonnull Calendar calendar) {
        ValueEnforcer.notNull((Object)calendar, (String)"Day");
        if (!super.isTimeIncluded(calendar.getTime().getTime())) {
            return true;
        }
        int n = calendar.get(2);
        int n2 = calendar.get(5);
        if (!this.m_bDataSorted) {
            Collections.sort(this.m_aExcludeDays, new CalendarComparator());
            this.m_bDataSorted = true;
        }
        for (Calendar calendar2 : this.m_aExcludeDays) {
            if (n < calendar2.get(2)) {
                return false;
            }
            if (n2 != calendar2.get(5) || n != calendar2.get(2)) continue;
            return true;
        }
        return false;
    }

    public void setDaysExcluded(@Nullable List<Calendar> list) {
        if (list == null) {
            this.m_aExcludeDays.clear();
        } else {
            this.m_aExcludeDays.setAll(list);
        }
        this.m_bDataSorted = false;
    }

    public void setDayExcluded(Calendar calendar, boolean bl) {
        if (bl) {
            if (!this.isDayExcluded(calendar)) {
                this.m_aExcludeDays.add((Object)calendar);
                this.m_bDataSorted = false;
            }
        } else if (this.isDayExcluded(calendar)) {
            this._removeExcludedDay(calendar, true);
        }
    }

    public void removeExcludedDay(Calendar calendar) {
        this._removeExcludedDay(calendar, false);
    }

    private void _removeExcludedDay(Calendar calendar, boolean bl) {
        Calendar calendar2 = calendar;
        if (!bl && !this.isDayExcluded(calendar2)) {
            return;
        }
        if (this.m_aExcludeDays.remove((Object)calendar2)) {
            return;
        }
        int n = calendar2.get(2);
        int n2 = calendar2.get(5);
        for (Calendar calendar3 : this.m_aExcludeDays) {
            if (n != calendar3.get(2) || n2 != calendar3.get(5)) continue;
            calendar2 = calendar3;
            break;
        }
        this.m_aExcludeDays.remove((Object)calendar2);
    }

    @Override
    public boolean isTimeIncluded(long l) {
        if (!super.isTimeIncluded(l)) {
            return false;
        }
        Calendar calendar = this.createJavaCalendar(l);
        return !this.isDayExcluded(calendar);
    }

    @Override
    public long getNextIncludedTime(long l) {
        Calendar calendar;
        long l2 = l;
        long l3 = super.getNextIncludedTime(l2);
        if (l3 > 0L && l3 > l2) {
            l2 = l3;
        }
        if (!this.isDayExcluded(calendar = this.getStartOfDayJavaCalendar(l2))) {
            return l2;
        }
        while (this.isDayExcluded(calendar)) {
            calendar.add(5, 1);
        }
        return calendar.getTime().getTime();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public AnnualCalendar getClone() {
        return new AnnualCalendar(this);
    }
}

