/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.impl.calendar;

import com.helger.commons.collection.ArrayHelper;
import com.helger.quartz.ICalendar;
import com.helger.quartz.impl.calendar.AbstractCalendar;
import java.util.Calendar;
import java.util.TimeZone;
import javax.annotation.Nonnull;

public class MonthlyCalendar
extends AbstractCalendar<MonthlyCalendar> {
    private static final int MAX_DAYS_IN_MONTH = 31;
    private boolean[] m_aExcludeDays = new boolean[31];
    private boolean m_bExcludeAll = false;

    public MonthlyCalendar(@Nonnull MonthlyCalendar monthlyCalendar) {
        super(monthlyCalendar);
        this.m_aExcludeDays = ArrayHelper.getCopy((boolean[])monthlyCalendar.m_aExcludeDays);
        this.m_bExcludeAll = monthlyCalendar.m_bExcludeAll;
    }

    public MonthlyCalendar() {
        this(null, null);
    }

    public MonthlyCalendar(ICalendar iCalendar) {
        this(iCalendar, null);
    }

    public MonthlyCalendar(TimeZone timeZone) {
        this(null, timeZone);
    }

    public MonthlyCalendar(ICalendar iCalendar, TimeZone timeZone) {
        super(iCalendar, timeZone);
        this.m_bExcludeAll = this.areAllDaysExcluded();
    }

    public boolean[] getDaysExcluded() {
        return this.m_aExcludeDays;
    }

    public boolean isDayExcluded(int n) {
        if (n < 1 || n > 31) {
            throw new IllegalArgumentException("The day parameter must be in the range of 1 to 31");
        }
        return this.m_aExcludeDays[n - 1];
    }

    public void setDaysExcluded(boolean[] blArray) {
        if (blArray == null) {
            throw new IllegalArgumentException("The days parameter cannot be null.");
        }
        if (blArray.length < 31) {
            throw new IllegalArgumentException("The days parameter must have a length of at least 31 elements.");
        }
        this.m_aExcludeDays = blArray;
        this.m_bExcludeAll = this.areAllDaysExcluded();
    }

    public void setDayExcluded(int n, boolean bl) {
        if (n < 1 || n > 31) {
            throw new IllegalArgumentException("The day parameter must be in the range of 1 to 31");
        }
        this.m_aExcludeDays[n - 1] = bl;
        this.m_bExcludeAll = this.areAllDaysExcluded();
    }

    public boolean areAllDaysExcluded() {
        for (int i = 1; i <= 31; ++i) {
            if (this.isDayExcluded(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTimeIncluded(long l) {
        if (this.m_bExcludeAll) {
            return false;
        }
        if (!super.isTimeIncluded(l)) {
            return false;
        }
        Calendar calendar = this.createJavaCalendar(l);
        int n = calendar.get(5);
        return !this.isDayExcluded(n);
    }

    @Override
    public long getNextIncludedTime(long l) {
        Calendar calendar;
        int n;
        if (this.m_bExcludeAll) {
            return 0L;
        }
        long l2 = l;
        long l3 = super.getNextIncludedTime(l2);
        if (l3 > 0L && l3 > l2) {
            l2 = l3;
        }
        if (!this.isDayExcluded(n = (calendar = this.getStartOfDayJavaCalendar(l2)).get(5))) {
            return l2;
        }
        while (this.isDayExcluded(n)) {
            calendar.add(5, 1);
            n = calendar.get(5);
        }
        return calendar.getTime().getTime();
    }

    @Override
    @Nonnull
    public MonthlyCalendar getClone() {
        return new MonthlyCalendar(this);
    }
}

