/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.impl.matchers;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.quartz.IMatcher;
import com.helger.quartz.utils.Key;
import javax.annotation.Nonnull;

public class NotMatcher<T extends Key<T>>
implements IMatcher<T> {
    private final IMatcher<T> m_aOperand;

    public NotMatcher(@Nonnull IMatcher<T> iMatcher) {
        ValueEnforcer.notNull(iMatcher, (String)"Operand");
        this.m_aOperand = iMatcher;
    }

    @Nonnull
    public IMatcher<T> getOperand() {
        return this.m_aOperand;
    }

    @Override
    public boolean isMatch(T t) {
        return !this.m_aOperand.isMatch(t);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        NotMatcher notMatcher = (NotMatcher)object;
        return this.m_aOperand.equals(notMatcher.m_aOperand);
    }

    @Override
    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aOperand).getHashCode();
    }
}

