/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.utils;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;

public class CircularLossyQueue<T> {
    private final AtomicReference<T>[] m_aCircularArray;
    private final int m_nMaxSize;
    private final AtomicLong m_aCurrentIndex = new AtomicLong(-1L);

    public CircularLossyQueue(int n) {
        this.m_aCircularArray = new AtomicReference[n];
        for (int i = 0; i < n; ++i) {
            this.m_aCircularArray[i] = new AtomicReference();
        }
        this.m_nMaxSize = n;
    }

    public void push(T t) {
        int n = (int)(this.m_aCurrentIndex.incrementAndGet() % (long)this.m_nMaxSize);
        this.m_aCircularArray[n].set(t);
    }

    public T[] toArray(@Nonnull T[] TArray) {
        if (TArray.length > this.m_nMaxSize) {
            throw new IllegalArgumentException("Size of array passed in cannot be greater than " + this.m_nMaxSize);
        }
        int n = this._getCurrentIndex();
        for (int i = 0; i < TArray.length; ++i) {
            int n2 = this._getIndex(n - i);
            TArray[i] = this.m_aCircularArray[n2].get();
        }
        return TArray;
    }

    private int _getIndex(int n) {
        return n < 0 ? n + this.m_nMaxSize : n;
    }

    public T peek() {
        if (this.depth() == 0) {
            return null;
        }
        return this.m_aCircularArray[this._getIndex(this._getCurrentIndex())].get();
    }

    public boolean isEmtpy() {
        return this.depth() == 0;
    }

    private int _getCurrentIndex() {
        return (int)(this.m_aCurrentIndex.get() % (long)this.m_nMaxSize);
    }

    public int depth() {
        long l = this.m_aCurrentIndex.get() + 1L;
        return l >= (long)this.m_nMaxSize ? this.m_nMaxSize : (int)l;
    }
}

