/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz;

import com.helger.commons.ValueEnforcer;
import com.helger.datetime.util.PDTHelper;
import com.helger.quartz.CronExpression;
import com.helger.quartz.DateBuilder;
import com.helger.quartz.IScheduleBuilder;
import com.helger.quartz.ITrigger;
import com.helger.quartz.impl.triggers.CronTrigger;
import java.text.ParseException;
import java.time.DayOfWeek;
import java.util.TimeZone;
import javax.annotation.Nonnull;

public class CronScheduleBuilder
implements IScheduleBuilder<CronTrigger> {
    private final CronExpression m_aCronExpression;
    private ITrigger.EMisfireInstruction m_eMisfireInstruction = ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_SMART_POLICY;

    protected CronScheduleBuilder(@Nonnull CronExpression cronExpression) {
        ValueEnforcer.notNull((Object)cronExpression, (String)"CronExpression");
        this.m_aCronExpression = cronExpression;
    }

    @Override
    @Nonnull
    public CronTrigger build() {
        CronTrigger cronTrigger = new CronTrigger();
        cronTrigger.setCronExpression(this.m_aCronExpression);
        cronTrigger.setTimeZone(this.m_aCronExpression.getTimeZone());
        cronTrigger.setMisfireInstruction(this.m_eMisfireInstruction);
        return cronTrigger;
    }

    @Nonnull
    public static CronScheduleBuilder cronSchedule(String string) {
        try {
            return CronScheduleBuilder.cronSchedule(new CronExpression(string));
        }
        catch (ParseException parseException) {
            throw new RuntimeException("CronExpression '" + string + "' is invalid.", parseException);
        }
    }

    @Nonnull
    public static CronScheduleBuilder cronScheduleNonvalidatedExpression(String string) throws ParseException {
        return CronScheduleBuilder.cronSchedule(new CronExpression(string));
    }

    @Nonnull
    private static CronScheduleBuilder _cronScheduleNoParseException(String string) {
        try {
            return CronScheduleBuilder.cronSchedule(new CronExpression(string));
        }
        catch (ParseException parseException) {
            throw new RuntimeException("CronExpression '" + string + "' is invalid, which should not be possible, please report bug to Quartz developers.", parseException);
        }
    }

    @Nonnull
    public static CronScheduleBuilder cronSchedule(CronExpression cronExpression) {
        return new CronScheduleBuilder(cronExpression);
    }

    @Nonnull
    public static CronScheduleBuilder dailyAtHourAndMinute(int n, int n2) {
        DateBuilder.validateHour(n);
        DateBuilder.validateMinute(n2);
        String string = "0 " + n2 + " " + n + " ? * *";
        return CronScheduleBuilder._cronScheduleNoParseException(string);
    }

    @Nonnull
    public static CronScheduleBuilder atHourAndMinuteOnGivenDaysOfWeek(int n, int n2, DayOfWeek ... dayOfWeekArray) {
        ValueEnforcer.notEmptyNoNullValue((Object[])dayOfWeekArray, (String)"DaysOfWeek");
        DateBuilder.validateHour(n);
        DateBuilder.validateMinute(n2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("0 ").append(n2).append(' ').append(n).append(" ? * ").append(PDTHelper.getCalendarDayOfWeek((DayOfWeek)dayOfWeekArray[0]));
        for (int i = 1; i < dayOfWeekArray.length; ++i) {
            stringBuilder.append(',').append(PDTHelper.getCalendarDayOfWeek((DayOfWeek)dayOfWeekArray[i]));
        }
        return CronScheduleBuilder._cronScheduleNoParseException(stringBuilder.toString());
    }

    @Nonnull
    public static CronScheduleBuilder weeklyOnDayAndHourAndMinute(DayOfWeek dayOfWeek, int n, int n2) {
        DateBuilder.validateDayOfWeek(dayOfWeek);
        DateBuilder.validateHour(n);
        DateBuilder.validateMinute(n2);
        String string = "0 " + n2 + " " + n + " ? * " + PDTHelper.getCalendarDayOfWeek((DayOfWeek)dayOfWeek);
        return CronScheduleBuilder._cronScheduleNoParseException(string);
    }

    @Nonnull
    public static CronScheduleBuilder monthlyOnDayAndHourAndMinute(int n, int n2, int n3) {
        DateBuilder.validateDayOfMonth(n);
        DateBuilder.validateHour(n2);
        DateBuilder.validateMinute(n3);
        String string = "0 " + n3 + " " + n2 + " " + n + " * ?";
        return CronScheduleBuilder._cronScheduleNoParseException(string);
    }

    @Nonnull
    public CronScheduleBuilder inTimeZone(TimeZone timeZone) {
        this.m_aCronExpression.setTimeZone(timeZone);
        return this;
    }

    @Nonnull
    public CronScheduleBuilder withMisfireHandlingInstructionIgnoreMisfires() {
        this.m_eMisfireInstruction = ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_IGNORE_MISFIRE_POLICY;
        return this;
    }

    @Nonnull
    public CronScheduleBuilder withMisfireHandlingInstructionDoNothing() {
        this.m_eMisfireInstruction = ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_DO_NOTHING;
        return this;
    }

    @Nonnull
    public CronScheduleBuilder withMisfireHandlingInstructionFireAndProceed() {
        this.m_eMisfireInstruction = ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_FIRE_ONCE_NOW;
        return this;
    }
}

