/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz;

import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.quartz.IScheduleBuilder;
import com.helger.quartz.JobDataMap;
import com.helger.quartz.JobKey;
import com.helger.quartz.TriggerBuilder;
import com.helger.quartz.TriggerKey;
import com.helger.quartz.spi.IMutableTrigger;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@MustImplementEqualsAndHashcode
public interface ITrigger
extends Comparable<ITrigger> {
    public static final int DEFAULT_PRIORITY = 5;

    @Nullable
    public TriggerKey getKey();

    @Nullable
    public JobKey getJobKey();

    @Nullable
    public String getDescription();

    @Nullable
    public String getCalendarName();

    @Nonnull
    public JobDataMap getJobDataMap();

    public int getPriority();

    public boolean mayFireAgain();

    public Date getStartTime();

    @Nullable
    public Date getEndTime();

    public Date getNextFireTime();

    public Date getPreviousFireTime();

    public Date getFireTimeAfter(Date var1);

    public Date getFinalFireTime();

    public EMisfireInstruction getMisfireInstruction();

    public TriggerBuilder<? extends ITrigger> getTriggerBuilder();

    public IScheduleBuilder<? extends IMutableTrigger> getScheduleBuilder();

    public boolean equals(Object var1);

    @Override
    public int compareTo(ITrigger var1);

    @Nonnull
    @ReturnsMutableCopy
    public ITrigger getClone();

    public static enum EMisfireInstruction {
        MISFIRE_INSTRUCTION_IGNORE_MISFIRE_POLICY,
        MISFIRE_INSTRUCTION_SMART_POLICY,
        MISFIRE_INSTRUCTION_FIRE_ONCE_NOW,
        MISFIRE_INSTRUCTION_DO_NOTHING,
        MISFIRE_INSTRUCTION_RESCHEDULE_NOW_WITH_EXISTING_REPEAT_COUNT,
        MISFIRE_INSTRUCTION_RESCHEDULE_NOW_WITH_REMAINING_REPEAT_COUNT,
        MISFIRE_INSTRUCTION_RESCHEDULE_NEXT_WITH_REMAINING_COUNT,
        MISFIRE_INSTRUCTION_RESCHEDULE_NEXT_WITH_EXISTING_COUNT;

    }

    public static enum ECompletedExecutionInstruction {
        NOOP,
        RE_EXECUTE_JOB,
        SET_TRIGGER_COMPLETE,
        DELETE_TRIGGER,
        SET_ALL_JOB_TRIGGERS_COMPLETE,
        SET_TRIGGER_ERROR,
        SET_ALL_JOB_TRIGGERS_ERROR;

    }

    public static enum ETriggerState {
        NONE,
        NORMAL,
        PAUSED,
        COMPLETE,
        ERROR,
        BLOCKED;

    }
}

