/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.impl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.quartz.DisallowConcurrentExecution;
import com.helger.quartz.IJob;
import com.helger.quartz.IJobDetail;
import com.helger.quartz.JobBuilder;
import com.helger.quartz.JobDataMap;
import com.helger.quartz.JobKey;
import com.helger.quartz.PersistJobDataAfterExecution;
import com.helger.quartz.QCloneUtils;
import com.helger.quartz.utils.ClassUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JobDetail
implements IJobDetail {
    private String m_sName;
    private String m_sGroup = "DEFAULT";
    private String m_sDescription;
    private Class<? extends IJob> m_aJobClass;
    private JobDataMap m_aJobDataMap;
    private boolean m_bDurability = false;
    private boolean m_bShouldRecover = false;
    private transient JobKey m_aKey;

    public JobDetail(@Nonnull JobDetail jobDetail) {
        ValueEnforcer.notNull((Object)jobDetail, (String)"Other");
        this.m_sName = jobDetail.m_sName;
        this.m_sGroup = jobDetail.m_sGroup;
        this.m_sDescription = jobDetail.m_sDescription;
        this.m_aJobClass = jobDetail.m_aJobClass;
        this.m_aJobDataMap = QCloneUtils.getClone(jobDetail.m_aJobDataMap);
        this.m_bDurability = jobDetail.m_bDurability;
        this.m_bShouldRecover = jobDetail.m_bShouldRecover;
        this.m_aKey = jobDetail.m_aKey;
    }

    public JobDetail() {
    }

    public final String getName() {
        return this.m_sName;
    }

    public final void setName(String string) {
        ValueEnforcer.notNull((Object)string, (String)"Name");
        ValueEnforcer.isFalse((boolean)string.trim().isEmpty(), (String)"Job name cannot be empty.");
        this.m_sName = string;
        this.m_aKey = null;
    }

    public final String getGroup() {
        return this.m_sGroup;
    }

    public final void setGroup(String string) {
        if (string != null) {
            ValueEnforcer.isFalse((boolean)string.trim().isEmpty(), (String)"Group name cannot be empty.");
        }
        this.m_sGroup = string == null ? "DEFAULT" : string;
        this.m_aKey = null;
    }

    @Nonnull
    public final String getFullName() {
        return this.m_sGroup + "." + this.m_sName;
    }

    @Override
    @Nullable
    public final JobKey getKey() {
        if (this.m_aKey == null) {
            if (this.m_sName == null) {
                return null;
            }
            this.m_aKey = new JobKey(this.m_sName, this.getGroup());
        }
        return this.m_aKey;
    }

    public final void setKey(@Nonnull JobKey jobKey) {
        ValueEnforcer.notNull((Object)jobKey, (String)"Key");
        this.setName(jobKey.getName());
        this.setGroup(jobKey.getGroup());
        this.m_aKey = jobKey;
    }

    @Override
    public final String getDescription() {
        return this.m_sDescription;
    }

    public final void setDescription(String string) {
        this.m_sDescription = string;
    }

    @Override
    public final Class<? extends IJob> getJobClass() {
        return this.m_aJobClass;
    }

    public final void setJobClass(Class<? extends IJob> clazz) {
        ValueEnforcer.notNull(clazz, (String)"JobClass");
        this.m_aJobClass = clazz;
    }

    @Override
    @Nonnull
    public JobDataMap getJobDataMap() {
        if (this.m_aJobDataMap == null) {
            this.m_aJobDataMap = new JobDataMap();
        }
        return this.m_aJobDataMap;
    }

    public void setJobDataMap(@Nullable JobDataMap jobDataMap) {
        this.m_aJobDataMap = jobDataMap;
    }

    public void setDurability(boolean bl) {
        this.m_bDurability = bl;
    }

    public void setRequestsRecovery(boolean bl) {
        this.m_bShouldRecover = bl;
    }

    @Override
    public boolean isDurable() {
        return this.m_bDurability;
    }

    @Override
    public boolean isPersistJobDataAfterExecution() {
        return ClassUtils.isAnnotationPresent(this.m_aJobClass, PersistJobDataAfterExecution.class);
    }

    @Override
    public boolean isConcurrentExectionDisallowed() {
        return ClassUtils.isAnnotationPresent(this.m_aJobClass, DisallowConcurrentExecution.class);
    }

    @Override
    public boolean requestsRecovery() {
        return this.m_bShouldRecover;
    }

    public String toString() {
        return "JobDetail '" + this.getFullName() + "':  jobClass: '" + (this.getJobClass() == null ? null : this.getJobClass().getName()) + " concurrentExectionDisallowed: " + this.isConcurrentExectionDisallowed() + " persistJobDataAfterExecution: " + this.isPersistJobDataAfterExecution() + " isDurable: " + this.isDurable() + " requestsRecovers: " + this.requestsRecovery();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JobDetail jobDetail = (JobDetail)object;
        return EqualsHelper.equals((Object)this.getKey(), (Object)jobDetail.getKey());
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.getKey()).getHashCode();
    }

    @Override
    @Nonnull
    public JobBuilder getJobBuilder() {
        return JobBuilder.newJob().ofType(this.getJobClass()).requestRecovery(this.requestsRecovery()).storeDurably(this.isDurable()).usingJobData(this.getJobDataMap()).withDescription(this.getDescription()).withIdentity(this.getKey());
    }

    @Nonnull
    public JobDetail getClone() {
        return new JobDetail(this);
    }

    @Nonnull
    public static JobDetail create(String string, String string2, Class<? extends IJob> clazz) {
        JobDetail jobDetail = new JobDetail();
        jobDetail.setName(string);
        jobDetail.setGroup(string2);
        jobDetail.setJobClass(clazz);
        return jobDetail;
    }
}

