/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.impl.triggers;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.datetime.PDTFactory;
import com.helger.datetime.util.PDTHelper;
import com.helger.quartz.CQuartz;
import com.helger.quartz.DailyTimeIntervalScheduleBuilder;
import com.helger.quartz.EIntervalUnit;
import com.helger.quartz.ICalendar;
import com.helger.quartz.IDailyTimeIntervalTrigger;
import com.helger.quartz.IScheduleBuilder;
import com.helger.quartz.ITrigger;
import com.helger.quartz.QCloneUtils;
import com.helger.quartz.SchedulerException;
import com.helger.quartz.impl.triggers.AbstractTrigger;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DailyTimeIntervalTrigger
extends AbstractTrigger<DailyTimeIntervalTrigger>
implements IDailyTimeIntervalTrigger {
    private Date m_aStartTime;
    private Date m_aEndTime;
    private Date m_aNextFireTime;
    private Date m_aPreviousFireTime;
    private int m_nRepeatCount = -1;
    private int m_nRepeatInterval = 1;
    private EIntervalUnit m_eRepeatIntervalUnit = EIntervalUnit.MINUTE;
    private EnumSet<DayOfWeek> m_aDaysOfWeek;
    private LocalTime m_aStartTimeOfDay;
    private LocalTime m_aEndTimeOfDay;
    private int m_nTimesTriggered = 0;
    private boolean m_bComplete = false;

    public DailyTimeIntervalTrigger(@Nonnull DailyTimeIntervalTrigger dailyTimeIntervalTrigger) {
        super(dailyTimeIntervalTrigger);
        this.m_aStartTime = QCloneUtils.getClone(dailyTimeIntervalTrigger.m_aStartTime);
        this.m_aEndTime = QCloneUtils.getClone(dailyTimeIntervalTrigger.m_aEndTime);
        this.m_aNextFireTime = QCloneUtils.getClone(dailyTimeIntervalTrigger.m_aNextFireTime);
        this.m_aPreviousFireTime = QCloneUtils.getClone(dailyTimeIntervalTrigger.m_aPreviousFireTime);
        this.m_nRepeatCount = dailyTimeIntervalTrigger.m_nRepeatCount;
        this.m_nRepeatInterval = dailyTimeIntervalTrigger.m_nRepeatInterval;
        this.m_eRepeatIntervalUnit = dailyTimeIntervalTrigger.m_eRepeatIntervalUnit;
        this.m_aDaysOfWeek = QCloneUtils.getClone(dailyTimeIntervalTrigger.m_aDaysOfWeek);
        this.m_aStartTimeOfDay = dailyTimeIntervalTrigger.m_aStartTimeOfDay;
        this.m_aEndTimeOfDay = dailyTimeIntervalTrigger.m_aEndTimeOfDay;
        this.m_nTimesTriggered = dailyTimeIntervalTrigger.m_nTimesTriggered;
        this.m_bComplete = dailyTimeIntervalTrigger.m_bComplete;
    }

    public DailyTimeIntervalTrigger() {
    }

    public DailyTimeIntervalTrigger(String string, LocalTime localTime, LocalTime localTime2, EIntervalUnit eIntervalUnit, int n) {
        this(string, null, localTime, localTime2, eIntervalUnit, n);
    }

    public DailyTimeIntervalTrigger(String string, String string2, LocalTime localTime, LocalTime localTime2, EIntervalUnit eIntervalUnit, int n) {
        this(string, string2, new Date(), null, localTime, localTime2, eIntervalUnit, n);
    }

    public DailyTimeIntervalTrigger(String string, Date date, Date date2, LocalTime localTime, LocalTime localTime2, EIntervalUnit eIntervalUnit, int n) {
        this(string, null, date, date2, localTime, localTime2, eIntervalUnit, n);
    }

    public DailyTimeIntervalTrigger(String string, String string2, Date date, Date date2, LocalTime localTime, LocalTime localTime2, EIntervalUnit eIntervalUnit, int n) {
        super(string, string2);
        this.setStartTime(date);
        this.setEndTime(date2);
        this.setRepeatIntervalUnit(eIntervalUnit);
        this.setRepeatInterval(n);
        this.setStartTimeOfDay(localTime);
        this.setEndTimeOfDay(localTime2);
    }

    public DailyTimeIntervalTrigger(String string, String string2, String string3, String string4, Date date, Date date2, LocalTime localTime, LocalTime localTime2, EIntervalUnit eIntervalUnit, int n) {
        super(string, string2, string3, string4);
        this.setStartTime(date);
        this.setEndTime(date2);
        this.setRepeatIntervalUnit(eIntervalUnit);
        this.setRepeatInterval(n);
        this.setStartTimeOfDay(localTime);
        this.setEndTimeOfDay(localTime2);
    }

    @Override
    @Nonnull
    public final Date getStartTime() {
        if (this.m_aStartTime == null) {
            this.m_aStartTime = new Date();
        }
        return this.m_aStartTime;
    }

    @Override
    public final void setStartTime(@Nonnull Date date) {
        ValueEnforcer.notNull((Object)date, (String)"StartTime");
        Date date2 = this.getEndTime();
        if (date2 != null && date2.before(date)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.m_aStartTime = date;
    }

    @Override
    @Nullable
    public final Date getEndTime() {
        return this.m_aEndTime;
    }

    @Override
    public final void setEndTime(@Nullable Date date) {
        Date date2 = this.getStartTime();
        if (date2 != null && date != null && date2.after(date)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.m_aEndTime = date;
    }

    @Override
    public EIntervalUnit getRepeatIntervalUnit() {
        return this.m_eRepeatIntervalUnit;
    }

    public void setRepeatIntervalUnit(EIntervalUnit eIntervalUnit) {
        if (this.m_eRepeatIntervalUnit == null || !this.m_eRepeatIntervalUnit.equals((Object)EIntervalUnit.SECOND) && !this.m_eRepeatIntervalUnit.equals((Object)EIntervalUnit.MINUTE) && !this.m_eRepeatIntervalUnit.equals((Object)EIntervalUnit.HOUR)) {
            throw new IllegalArgumentException("Invalid repeat IntervalUnit (must be SECOND, MINUTE or HOUR).");
        }
        this.m_eRepeatIntervalUnit = eIntervalUnit;
    }

    @Override
    public int getRepeatInterval() {
        return this.m_nRepeatInterval;
    }

    public void setRepeatInterval(int n) {
        ValueEnforcer.isGE0((int)n, (String)"RepeatInterval");
        this.m_nRepeatInterval = n;
    }

    @Override
    public int getTimesTriggered() {
        return this.m_nTimesTriggered;
    }

    public void setTimesTriggered(int n) {
        this.m_nTimesTriggered = n;
    }

    @Override
    protected boolean validateMisfireInstruction(ITrigger.EMisfireInstruction eMisfireInstruction) {
        switch (eMisfireInstruction) {
            case MISFIRE_INSTRUCTION_IGNORE_MISFIRE_POLICY: 
            case MISFIRE_INSTRUCTION_SMART_POLICY: 
            case MISFIRE_INSTRUCTION_FIRE_ONCE_NOW: 
            case MISFIRE_INSTRUCTION_DO_NOTHING: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void updateAfterMisfire(ICalendar iCalendar) {
        ITrigger.EMisfireInstruction eMisfireInstruction = this.getMisfireInstruction();
        if (eMisfireInstruction == ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_SMART_POLICY) {
            eMisfireInstruction = ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_FIRE_ONCE_NOW;
        }
        switch (eMisfireInstruction) {
            case MISFIRE_INSTRUCTION_IGNORE_MISFIRE_POLICY: {
                return;
            }
            case MISFIRE_INSTRUCTION_FIRE_ONCE_NOW: {
                this.setNextFireTime(new Date());
                break;
            }
            case MISFIRE_INSTRUCTION_DO_NOTHING: {
                Date date = this.getFireTimeAfter(new Date());
                while (date != null && iCalendar != null && !iCalendar.isTimeIncluded(date.getTime())) {
                    date = this.getFireTimeAfter(date);
                }
                this.setNextFireTime(date);
                break;
            }
        }
    }

    @Override
    public void triggered(ICalendar iCalendar) {
        ++this.m_nTimesTriggered;
        this.m_aPreviousFireTime = this.m_aNextFireTime;
        this.m_aNextFireTime = this.getFireTimeAfter(this.m_aNextFireTime);
        while (this.m_aNextFireTime != null && iCalendar != null && !iCalendar.isTimeIncluded(this.m_aNextFireTime.getTime())) {
            this.m_aNextFireTime = this.getFireTimeAfter(this.m_aNextFireTime);
            if (this.m_aNextFireTime == null) break;
            Calendar calendar = PDTFactory.createCalendar();
            calendar.setTime(this.m_aNextFireTime);
            if (calendar.get(1) <= CQuartz.MAX_YEAR) continue;
            this.m_aNextFireTime = null;
        }
        if (this.m_aNextFireTime == null) {
            this.m_bComplete = true;
        }
    }

    @Override
    public void updateWithNewCalendar(ICalendar iCalendar, long l) {
        this.m_aNextFireTime = this.getFireTimeAfter(this.m_aPreviousFireTime);
        if (this.m_aNextFireTime == null || iCalendar == null) {
            return;
        }
        Date date = new Date();
        while (this.m_aNextFireTime != null && !iCalendar.isTimeIncluded(this.m_aNextFireTime.getTime())) {
            long l2;
            this.m_aNextFireTime = this.getFireTimeAfter(this.m_aNextFireTime);
            if (this.m_aNextFireTime == null) break;
            Calendar calendar = PDTFactory.createCalendar();
            calendar.setTime(this.m_aNextFireTime);
            if (calendar.get(1) > CQuartz.MAX_YEAR) {
                this.m_aNextFireTime = null;
            }
            if (this.m_aNextFireTime == null || !this.m_aNextFireTime.before(date) || (l2 = date.getTime() - this.m_aNextFireTime.getTime()) < l) continue;
            this.m_aNextFireTime = this.getFireTimeAfter(this.m_aNextFireTime);
        }
    }

    @Override
    public Date computeFirstFireTime(ICalendar iCalendar) {
        this.m_aNextFireTime = this.getFireTimeAfter(new Date(this.getStartTime().getTime() - 1000L));
        while (this.m_aNextFireTime != null && iCalendar != null && !iCalendar.isTimeIncluded(this.m_aNextFireTime.getTime())) {
            this.m_aNextFireTime = this.getFireTimeAfter(this.m_aNextFireTime);
            if (this.m_aNextFireTime == null) break;
            Calendar calendar = PDTFactory.createCalendar();
            calendar.setTime(this.m_aNextFireTime);
            if (calendar.get(1) <= CQuartz.MAX_YEAR) continue;
            return null;
        }
        return this.m_aNextFireTime;
    }

    @Nonnull
    private static Calendar _createCalendarTime(Date date) {
        Calendar calendar = PDTFactory.createCalendar();
        calendar.setTime(date);
        return calendar;
    }

    @Override
    public Date getNextFireTime() {
        return this.m_aNextFireTime;
    }

    @Override
    public Date getPreviousFireTime() {
        return this.m_aPreviousFireTime;
    }

    @Override
    public void setNextFireTime(Date date) {
        this.m_aNextFireTime = date;
    }

    @Override
    public void setPreviousFireTime(Date date) {
        this.m_aPreviousFireTime = date;
    }

    @Override
    public Date getFireTimeAfter(@Nullable Date date) {
        Date date2;
        if (this.m_bComplete) {
            return null;
        }
        if (this.m_nRepeatCount != -1 && this.m_nTimesTriggered > this.m_nRepeatCount) {
            return null;
        }
        Date date3 = date;
        date3 = date3 == null ? new Date(System.currentTimeMillis() + 1000L) : new Date(date3.getTime() + 1000L);
        if (date3.before(this.m_aStartTime)) {
            date3 = this.m_aStartTime;
        }
        boolean bl = false;
        if (this.m_aEndTimeOfDay != null) {
            boolean bl2 = bl = date3.getTime() > CQuartz.onDate(this.m_aEndTimeOfDay, date3).getTime();
        }
        if ((date2 = this._advanceToNextDayOfWeekIfNecessary(date3, bl)) == null) {
            return null;
        }
        Date date4 = this.m_aEndTimeOfDay == null ? CQuartz.onDate(PDTFactory.createLocalTime((int)23, (int)59, (int)59), date2) : CQuartz.onDate(this.m_aEndTimeOfDay, date2);
        Date date5 = CQuartz.onDate(this.m_aStartTimeOfDay, date2);
        if (date2.before(date5)) {
            return date5;
        }
        long l = date2.getTime();
        long l2 = date5.getTime();
        long l3 = (l - l2) / 1000L;
        long l4 = this.getRepeatInterval();
        Calendar calendar = DailyTimeIntervalTrigger._createCalendarTime(date5);
        EIntervalUnit eIntervalUnit = this.getRepeatIntervalUnit();
        if (eIntervalUnit.equals((Object)EIntervalUnit.SECOND)) {
            long l5 = l3 / l4;
            if (l3 % l4 != 0L) {
                ++l5;
            }
            calendar.add(13, this.getRepeatInterval() * (int)l5);
            date2 = calendar.getTime();
        } else if (eIntervalUnit.equals((Object)EIntervalUnit.MINUTE)) {
            long l6 = l3 / (l4 * 60L);
            if (l3 % (l4 * 60L) != 0L) {
                ++l6;
            }
            calendar.add(12, this.getRepeatInterval() * (int)l6);
            date2 = calendar.getTime();
        } else if (eIntervalUnit.equals((Object)EIntervalUnit.HOUR)) {
            long l7 = l3 / (l4 * 60L * 60L);
            if (l3 % (l4 * 60L * 60L) != 0L) {
                ++l7;
            }
            calendar.add(11, this.getRepeatInterval() * (int)l7);
            date2 = calendar.getTime();
        }
        if (date2.after(date4)) {
            date2 = this._advanceToNextDayOfWeekIfNecessary(date2, DailyTimeIntervalTrigger._isSameDay(date2, date4));
            date2 = CQuartz.onDate(this.m_aStartTimeOfDay, date2);
        }
        return date2;
    }

    private static boolean _isSameDay(Date date, Date date2) {
        Calendar calendar = DailyTimeIntervalTrigger._createCalendarTime(date);
        Calendar calendar2 = DailyTimeIntervalTrigger._createCalendarTime(date2);
        return calendar.get(1) == calendar2.get(1) && calendar.get(6) == calendar2.get(6);
    }

    private Date _advanceToNextDayOfWeekIfNecessary(Date date, boolean bl) {
        Date date2;
        int n;
        Date date3 = date;
        LocalTime localTime = this.getStartTimeOfDay();
        Date date4 = CQuartz.onDate(localTime, date3);
        Calendar calendar = DailyTimeIntervalTrigger._createCalendarTime(date4);
        int n2 = n = calendar.get(7);
        DayOfWeek dayOfWeek = PDTHelper.getAsDayOfWeek((int)n2);
        Set<DayOfWeek> set = this.getDaysOfWeek();
        if (bl || !set.contains(dayOfWeek)) {
            for (int i = 1; i <= 7; ++i) {
                calendar.add(5, 1);
                int n3 = n = calendar.get(7);
                dayOfWeek = PDTHelper.getAsDayOfWeek((int)n3);
                if (!set.contains(dayOfWeek)) continue;
                date3 = calendar.getTime();
                break;
            }
        }
        if ((date2 = this.getEndTime()) != null && date3.getTime() > date2.getTime()) {
            return null;
        }
        return date3;
    }

    @Override
    public Date getFinalFireTime() {
        if (this.m_bComplete || this.getEndTime() == null) {
            return null;
        }
        Date date = this.getEndTime();
        if (this.m_aEndTimeOfDay != null) {
            Date date2 = CQuartz.onDate(this.m_aEndTimeOfDay, date);
            if (date.getTime() < date2.getTime()) {
                date = date2;
            }
        }
        return date;
    }

    @Override
    public boolean mayFireAgain() {
        return this.getNextFireTime() != null;
    }

    @Override
    public void validate() throws SchedulerException {
        super.validate();
        if (this.m_eRepeatIntervalUnit == null || !this.m_eRepeatIntervalUnit.equals((Object)EIntervalUnit.SECOND) && !this.m_eRepeatIntervalUnit.equals((Object)EIntervalUnit.MINUTE) && !this.m_eRepeatIntervalUnit.equals((Object)EIntervalUnit.HOUR)) {
            throw new SchedulerException("Invalid repeat IntervalUnit (must be SECOND, MINUTE or HOUR).");
        }
        if (this.m_nRepeatInterval < 1) {
            throw new SchedulerException("Repeat Interval cannot be zero.");
        }
        if (this.m_eRepeatIntervalUnit == EIntervalUnit.SECOND && (long)this.m_nRepeatInterval > 86400L) {
            throw new SchedulerException("repeatInterval can not exceed 24 hours (86400 seconds). Given " + this.m_nRepeatInterval);
        }
        if (this.m_eRepeatIntervalUnit == EIntervalUnit.MINUTE && (long)this.m_nRepeatInterval > 1440L) {
            throw new SchedulerException("repeatInterval can not exceed 24 hours (1440 minutes). Given " + this.m_nRepeatInterval);
        }
        if (this.m_eRepeatIntervalUnit == EIntervalUnit.HOUR && this.m_nRepeatInterval > 24) {
            throw new SchedulerException("repeatInterval can not exceed 24 hours. Given " + this.m_nRepeatInterval + " hours.");
        }
        if (this.getEndTimeOfDay() != null && !this.getStartTimeOfDay().isBefore(this.getEndTimeOfDay())) {
            throw new SchedulerException("StartTimeOfDay " + this.m_aStartTimeOfDay + " should not come after endTimeOfDay " + this.m_aEndTimeOfDay);
        }
    }

    @Override
    public Set<DayOfWeek> getDaysOfWeek() {
        if (this.m_aDaysOfWeek == null) {
            this.m_aDaysOfWeek = EnumSet.allOf(DayOfWeek.class);
        }
        return this.m_aDaysOfWeek;
    }

    public void setDaysOfWeek(Set<DayOfWeek> set) {
        ValueEnforcer.notEmpty(set, (String)"DaysOfWeek");
        this.m_aDaysOfWeek = EnumSet.copyOf(set);
    }

    @Override
    public LocalTime getStartTimeOfDay() {
        if (this.m_aStartTimeOfDay == null) {
            this.m_aStartTimeOfDay = LocalTime.MIDNIGHT;
        }
        return this.m_aStartTimeOfDay;
    }

    public void setStartTimeOfDay(LocalTime localTime) {
        ValueEnforcer.notNull((Object)localTime, (String)"StartTimeOfDay");
        LocalTime localTime2 = this.getEndTimeOfDay();
        if (localTime2 != null && localTime2.isBefore(localTime)) {
            throw new IllegalArgumentException("End time of day cannot be before start time of day");
        }
        this.m_aStartTimeOfDay = localTime;
    }

    @Override
    public LocalTime getEndTimeOfDay() {
        return this.m_aEndTimeOfDay;
    }

    public void setEndTimeOfDay(LocalTime localTime) {
        ValueEnforcer.notNull((Object)localTime, (String)"EndTimeOfDay");
        LocalTime localTime2 = this.getStartTimeOfDay();
        if (localTime2 != null && localTime.isBefore(localTime)) {
            throw new IllegalArgumentException("End time of day cannot be before start time of day");
        }
        this.m_aEndTimeOfDay = localTime;
    }

    @Override
    public IScheduleBuilder<DailyTimeIntervalTrigger> getScheduleBuilder() {
        DailyTimeIntervalScheduleBuilder dailyTimeIntervalScheduleBuilder = DailyTimeIntervalScheduleBuilder.dailyTimeIntervalSchedule().withInterval(this.getRepeatInterval(), this.getRepeatIntervalUnit()).onDaysOfTheWeek(this.getDaysOfWeek()).startingDailyAt(this.getStartTimeOfDay()).endingDailyAt(this.getEndTimeOfDay());
        switch (this.getMisfireInstruction()) {
            case MISFIRE_INSTRUCTION_DO_NOTHING: {
                dailyTimeIntervalScheduleBuilder.withMisfireHandlingInstructionDoNothing();
                break;
            }
            case MISFIRE_INSTRUCTION_FIRE_ONCE_NOW: {
                dailyTimeIntervalScheduleBuilder.withMisfireHandlingInstructionFireAndProceed();
            }
        }
        return dailyTimeIntervalScheduleBuilder;
    }

    @Override
    public int getRepeatCount() {
        return this.m_nRepeatCount;
    }

    public void setRepeatCount(int n) {
        if (n < 0 && n != -1) {
            throw new IllegalArgumentException("Repeat count must be >= 0, use the constant REPEAT_INDEFINITELY for infinite.");
        }
        this.m_nRepeatCount = n;
    }

    @Override
    @Nonnull
    public DailyTimeIntervalTrigger getClone() {
        return new DailyTimeIntervalTrigger(this);
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

