/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.listeners;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.ITrigger;
import com.helger.quartz.ITriggerListener;
import javax.annotation.Nonnull;

public class BroadcastTriggerListener
implements ITriggerListener {
    private final String m_sName;
    private final ICommonsList<ITriggerListener> m_aListeners = new CommonsArrayList();

    public BroadcastTriggerListener(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Name");
        this.m_sName = string;
    }

    public BroadcastTriggerListener(@Nonnull String string, Iterable<? extends ITriggerListener> iterable) {
        this(string);
        this.m_aListeners.addAll(iterable);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.m_sName;
    }

    public void addListener(@Nonnull ITriggerListener iTriggerListener) {
        ValueEnforcer.notNull((Object)iTriggerListener, (String)"Listener");
        this.m_aListeners.add((Object)iTriggerListener);
    }

    public boolean removeListener(ITriggerListener iTriggerListener) {
        return this.m_aListeners.remove((Object)iTriggerListener);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ITriggerListener> getListeners() {
        return (ICommonsList)this.m_aListeners.getClone();
    }

    @Override
    public void triggerFired(ITrigger iTrigger, IJobExecutionContext iJobExecutionContext) {
        this.m_aListeners.forEach(iTriggerListener -> iTriggerListener.triggerFired(iTrigger, iJobExecutionContext));
    }

    @Override
    public boolean vetoJobExecution(ITrigger iTrigger, IJobExecutionContext iJobExecutionContext) {
        return this.m_aListeners.containsAny(iTriggerListener -> iTriggerListener.vetoJobExecution(iTrigger, iJobExecutionContext));
    }

    @Override
    public void triggerMisfired(ITrigger iTrigger) {
        this.m_aListeners.forEach(iTriggerListener -> iTriggerListener.triggerMisfired(iTrigger));
    }

    @Override
    public void triggerComplete(ITrigger iTrigger, IJobExecutionContext iJobExecutionContext, ITrigger.ECompletedExecutionInstruction eCompletedExecutionInstruction) {
        this.m_aListeners.forEach(iTriggerListener -> iTriggerListener.triggerComplete(iTrigger, iJobExecutionContext, eCompletedExecutionInstruction));
    }
}

