/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.listeners;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.IJobListener;
import com.helger.quartz.JobExecutionException;
import com.helger.quartz.JobKey;
import com.helger.quartz.SchedulerException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobChainingJobListener
implements IJobListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobChainingJobListener.class);
    private final String m_sName;
    private final ICommonsMap<JobKey, JobKey> m_aChainLinks = new CommonsHashMap();

    public JobChainingJobListener(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Name");
        this.m_sName = string;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.m_sName;
    }

    public void addJobChainLink(JobKey jobKey, JobKey jobKey2) {
        ValueEnforcer.notNull((Object)jobKey, (String)"FirstJob");
        ValueEnforcer.notNull((Object)jobKey.getName(), (String)"FirstJob.Name");
        ValueEnforcer.notNull((Object)jobKey2, (String)"SecondJob");
        ValueEnforcer.notNull((Object)jobKey2.getName(), (String)"SecondJob.Name");
        this.m_aChainLinks.put((Object)jobKey, (Object)jobKey2);
    }

    @Override
    public void jobWasExecuted(@Nonnull IJobExecutionContext iJobExecutionContext, JobExecutionException jobExecutionException) {
        JobKey jobKey = (JobKey)this.m_aChainLinks.get((Object)iJobExecutionContext.getJobDetail().getKey());
        if (jobKey == null) {
            return;
        }
        LOGGER.info("Job '" + iJobExecutionContext.getJobDetail().getKey() + "' will now chain to Job '" + jobKey + "'");
        try {
            iJobExecutionContext.getScheduler().triggerJob(jobKey);
        }
        catch (SchedulerException schedulerException) {
            LOGGER.error("Error encountered during chaining to Job '" + jobKey + "'", (Throwable)schedulerException);
        }
    }
}

