/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.simpl;

import com.helger.commons.string.StringHelper;
import com.helger.quartz.SchedulerException;
import com.helger.quartz.spi.IInstanceIdGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SystemPropertyInstanceIdGenerator
implements IInstanceIdGenerator {
    public static final String SYSTEM_PROPERTY = "org.quartz.scheduler.instanceId";
    private String m_sPrepend;
    private String m_sPostpend;
    private String m_sSystemPropertyName = "org.quartz.scheduler.instanceId";

    @Override
    public String generateInstanceId() throws SchedulerException {
        Object object = System.getProperty(this.getSystemPropertyName());
        if (object == null) {
            throw new SchedulerException("No value for 'org.quartz.scheduler.instanceId' system property found, please configure your environment accordingly!");
        }
        if (this.getPrepend() != null) {
            object = this.getPrepend() + (String)object;
        }
        if (this.getPostpend() != null) {
            object = (String)object + this.getPostpend();
        }
        return object;
    }

    @Nullable
    public String getPrepend() {
        return this.m_sPrepend;
    }

    public void setPrepend(@Nullable String string) {
        this.m_sPrepend = StringHelper.trim((String)string);
    }

    @Nullable
    public String getPostpend() {
        return this.m_sPostpend;
    }

    public void setPostpend(@Nullable String string) {
        this.m_sPostpend = StringHelper.trim((String)string);
    }

    @Nonnull
    public String getSystemPropertyName() {
        return this.m_sSystemPropertyName;
    }

    public void setSystemPropertyName(@Nullable String string) {
        this.m_sSystemPropertyName = string == null ? SYSTEM_PROPERTY : string.trim();
    }
}

