/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schedule.quartz;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.state.EChange;
import com.helger.quartz.IJob;
import com.helger.quartz.IJobDetail;
import com.helger.quartz.IJobListener;
import com.helger.quartz.IMatcher;
import com.helger.quartz.IScheduleBuilder;
import com.helger.quartz.IScheduler;
import com.helger.quartz.ITrigger;
import com.helger.quartz.JobBuilder;
import com.helger.quartz.SchedulerException;
import com.helger.quartz.SimpleScheduleBuilder;
import com.helger.quartz.TriggerKey;
import com.helger.quartz.impl.matchers.EverythingMatcher;
import com.helger.schedule.quartz.QuartzSchedulerHelper;
import com.helger.schedule.quartz.listener.StatisticsJobListener;
import com.helger.schedule.quartz.trigger.JDK8TriggerBuilder;
import com.helger.scope.IScope;
import com.helger.scope.singleton.AbstractGlobalSingleton;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GlobalQuartzScheduler
extends AbstractGlobalSingleton {
    public static final String GROUP_NAME = "com.helger";
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalQuartzScheduler.class);
    private final IScheduler m_aScheduler = QuartzSchedulerHelper.getScheduler(true);
    private String m_sGroupName = "com.helger";

    @Deprecated
    @UsedViaReflection
    public GlobalQuartzScheduler() {
        this.addJobListener(new StatisticsJobListener());
    }

    @Nonnull
    public static GlobalQuartzScheduler getInstance() {
        return (GlobalQuartzScheduler)GlobalQuartzScheduler.getGlobalSingleton(GlobalQuartzScheduler.class);
    }

    @Nonnull
    @Nonempty
    public String getGroupName() {
        return this.m_sGroupName;
    }

    public void setGroupName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"GroupName");
        this.m_sGroupName = string;
    }

    public void addJobListener(@Nonnull IJobListener iJobListener) {
        ValueEnforcer.notNull((Object)iJobListener, (String)"JobListener");
        try {
            this.m_aScheduler.getListenerManager().addJobListener(iJobListener, (IMatcher)EverythingMatcher.allJobs());
        }
        catch (SchedulerException schedulerException) {
            throw new IllegalStateException("Failed to add job listener " + iJobListener.toString(), schedulerException);
        }
    }

    @Nonnull
    public IScheduler getScheduler() {
        return this.m_aScheduler;
    }

    @Nonnull
    public TriggerKey scheduleJob(@Nonnull String string, @Nonnull JDK8TriggerBuilder<? extends ITrigger> jDK8TriggerBuilder, @Nonnull Class<? extends IJob> clazz, @Nullable Map<String, ? extends Object> map) {
        ValueEnforcer.notNull((Object)string, (String)"JobName");
        ValueEnforcer.notNull(jDK8TriggerBuilder, (String)"TriggerBuilder");
        ValueEnforcer.notNull(clazz, (String)"JobClass");
        IJobDetail iJobDetail = JobBuilder.newJob(clazz).withIdentity(string, this.m_sGroupName).build();
        iJobDetail.getJobDataMap().putAllIn(map);
        try {
            ITrigger iTrigger = jDK8TriggerBuilder.build();
            this.m_aScheduler.scheduleJob(iJobDetail, iTrigger);
            TriggerKey triggerKey = iTrigger.getKey();
            LOGGER.info("Succesfully scheduled job '" + string + "' with TriggerKey " + triggerKey.toString() + " - starting at " + PDTFactory.createLocalDateTime((Date)iTrigger.getStartTime()));
            return triggerKey;
        }
        catch (SchedulerException schedulerException) {
            throw new RuntimeException(schedulerException);
        }
    }

    @Nonnull
    public TriggerKey scheduleJobNowOnce(@Nonnull String string, @Nonnull Class<? extends IJob> clazz, @Nullable Map<String, ? extends Object> map) {
        return this.scheduleJob(string, JDK8TriggerBuilder.newTrigger().startNow().withSchedule((IScheduleBuilder<ITrigger>)SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(1).withRepeatCount(0)), clazz, map);
    }

    @Nonnull
    public EChange unscheduleJob(@Nonnull TriggerKey triggerKey) {
        ValueEnforcer.notNull((Object)triggerKey, (String)"TriggerKey");
        try {
            if (this.m_aScheduler.unscheduleJob(triggerKey)) {
                LOGGER.info("Succesfully unscheduled job with TriggerKey " + triggerKey.toString());
                return EChange.CHANGED;
            }
        }
        catch (SchedulerException schedulerException) {
            LOGGER.error("Failed to unschedule job with TriggerKey " + triggerKey.toString(), (Throwable)schedulerException);
        }
        return EChange.UNCHANGED;
    }

    public void pauseJob(@Nonnull TriggerKey triggerKey) {
        ValueEnforcer.notNull((Object)triggerKey, (String)"TriggerKey");
        try {
            this.m_aScheduler.pauseTrigger(triggerKey);
            LOGGER.info("Succesfully paused job with TriggerKey " + triggerKey.toString());
        }
        catch (SchedulerException schedulerException) {
            LOGGER.error("Failed to pause job with TriggerKey " + triggerKey.toString(), (Throwable)schedulerException);
        }
    }

    public void resumeJob(@Nonnull TriggerKey triggerKey) {
        ValueEnforcer.notNull((Object)triggerKey, (String)"TriggerKey");
        try {
            this.m_aScheduler.resumeTrigger(triggerKey);
            LOGGER.info("Succesfully resumed job with TriggerKey " + triggerKey.toString());
        }
        catch (SchedulerException schedulerException) {
            LOGGER.error("Failed to resume job with TriggerKey " + triggerKey.toString(), (Throwable)schedulerException);
        }
    }

    public void shutdown() throws SchedulerException {
        try {
            this.m_aScheduler.shutdown(true);
            LOGGER.info("Successfully shutdown GlobalQuartzScheduler");
        }
        catch (SchedulerException schedulerException) {
            LOGGER.error("Failed to shutdown GlobalQuartzScheduler", (Throwable)schedulerException);
            throw schedulerException;
        }
    }

    protected void onDestroy(@Nonnull IScope iScope) throws Exception {
        this.shutdown();
    }
}

